/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.var;

import ghidra.pcode.emu.jit.var.AbstractJitVar;
import ghidra.pcode.emu.jit.var.JitVarnodeVar;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.pcode.Varnode;

public abstract class AbstractJitVarnodeVar
extends AbstractJitVar
implements JitVarnodeVar {
    protected final Varnode varnode;

    public AbstractJitVarnodeVar(int id, Varnode varnode) {
        super(id, varnode.getSize());
        if (varnode.getSize() < 1) {
            throw new IllegalArgumentException("Varnode must have size at least 1");
        }
        this.varnode = varnode;
    }

    @Override
    public Varnode varnode() {
        return this.varnode;
    }

    @Override
    public AddressSpace space() {
        return this.varnode.getAddress().getAddressSpace();
    }

    @Override
    public String toString() {
        return "%s[id=%d,varnode=%s]".formatted(this.getClass().getSimpleName(), this.id, this.varnode);
    }
}

