/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.MixedLayoutBackgroundColorManager;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import docking.widgets.fieldpanel.support.Highlight;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class MixedFieldBackgroundColorManager
implements FieldBackgroundColorManager {
    private final Color selectionColor;
    private final FieldSelection selection;
    private final BigInteger index;
    private final int fieldNum;
    private final MixedLayoutBackgroundColorManager layoutSelection;
    private final Color backgroundColor;

    public MixedFieldBackgroundColorManager(BigInteger index, int fieldNum, MixedLayoutBackgroundColorManager layoutSelection, Color selectionColor, Color backgroundColor) {
        this.index = index;
        this.fieldNum = fieldNum;
        this.layoutSelection = layoutSelection;
        this.backgroundColor = backgroundColor;
        this.selection = layoutSelection.getSelection();
        this.selectionColor = selectionColor;
    }

    @Override
    public List<Highlight> getSelectionHighlights(int row) {
        FieldLocation start = new FieldLocation(this.index, this.fieldNum, row, 0);
        FieldLocation end = new FieldLocation(this.index, this.fieldNum, row + 1, 0);
        FieldSelection intersect = this.selection.intersect(new FieldRange(start, end));
        ArrayList<Highlight> highlights = new ArrayList<Highlight>(intersect.getNumRanges());
        for (int i = 0; i < intersect.getNumRanges(); ++i) {
            FieldRange range = intersect.getFieldRange(i);
            int min = range.getStart().col;
            int max = range.getEnd().row == row ? range.getEnd().col : Integer.MAX_VALUE;
            highlights.add(new Highlight(min, max, this.selectionColor));
        }
        return highlights;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.layoutSelection.getBackgroundColor() == this.backgroundColor) {
            return null;
        }
        return this.backgroundColor;
    }

    @Override
    public Color getPaddingColor(int padIndex) {
        return this.layoutSelection.getPaddingColor(this.fieldNum + padIndex);
    }
}

