/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.cmd;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.pe.FileHeader;
import ghidra.app.util.bin.format.pe.ImportInfo;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.SectionHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.PeLoader;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DumpPeShim
extends PeLoader {
    private ProgramDB program;
    private ProgramFragment fragment;
    private ProgramModule rootModule;
    private ProgramModule module;

    public DumpPeShim(ProgramDB program) {
        this.program = program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program pgm, ProgramFragment frag, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        Collection loadSpecs = this.findSupportedLoadSpecs(provider);
        if (loadSpecs.isEmpty()) {
            Msg.error((Object)((Object)this), (Object)("Not a valid PE image: " + frag.getName()));
            return;
        }
        this.generateModule(pgm, frag);
        Address minAddress = this.module.getMinAddress();
        if (minAddress.getOffset() == 0L) {
            Msg.warn((Object)((Object)this), (Object)"Zero-based fragment - skipping");
            return;
        }
        this.program.setEffectiveImageBase(minAddress);
        try {
            this.load(provider, loadSpec, options, (Program)this.program, monitor, log);
            monitor.checkCancelled();
        }
        finally {
            this.program.setEffectiveImageBase(null);
        }
        this.shiftModule();
    }

    private void generateModule(Program pgm, ProgramFragment frag) {
        this.rootModule = pgm.getListing().getRootModule(0L);
        this.fragment = frag;
        String name = this.fragment.getName();
        try {
            this.fragment.setName(name + "_pad");
            this.module = this.rootModule.createModule(name);
            this.module.reparent(name + "_pad", this.rootModule);
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)((Object)this), (Object)("Unable to convert " + name));
        }
        catch (NotFoundException e) {
            Msg.error((Object)((Object)this), (Object)("Unable to reparent " + name));
        }
    }

    private void shiftModule() {
        try {
            this.module.moveChild(this.module.getName() + "_pad", this.module.getNumChildren() - 1);
        }
        catch (NotFoundException e) {
            Msg.error((Object)((Object)this), (Object)("Unable to reparent " + this.module.getName()));
        }
    }

    protected PortableExecutable.SectionLayout getSectionLayout() {
        return PortableExecutable.SectionLayout.MEMORY;
    }

    protected FileBytes createFileBytes(ByteProvider provider, Program pgm, TaskMonitor monitor) throws IOException, CancelledException {
        List fileBytesList = pgm.getMemory().getAllFileBytes();
        return (FileBytes)fileBytesList.get(0);
    }

    private void adjustBlock(Address address, long size, String name) {
        String fragmentName = this.module.getName() + "_" + name;
        try {
            MemoryMapDB memory = this.program.getMemory();
            if (memory.contains(address)) {
                ProgramFragment frag = this.module.createFragment(fragmentName);
                frag.move(address, address.add(size - 1L));
            }
        }
        catch (NotFoundException e) {
            Msg.warn((Object)((Object)this), (Object)("Fragment not in memory " + fragmentName));
        }
        catch (NullPointerException e) {
            Msg.error((Object)((Object)this), (Object)("Unable to reparent " + fragmentName));
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
    }

    protected Map<SectionHeader, Address> processMemoryBlocks(PortableExecutable pe, Program prog, FileBytes fileBytes, TaskMonitor monitor, MessageLog log) throws AddressOverflowException {
        AddressFactory af = prog.getAddressFactory();
        AddressSpace space = af.getDefaultAddressSpace();
        HashMap<SectionHeader, Address> sectionToAddress = new HashMap<SectionHeader, Address>();
        if (monitor.isCancelled()) {
            return sectionToAddress;
        }
        monitor.setMessage("[" + prog.getName() + "]: processing memory blocks...");
        NTHeader ntHeader = pe.getNTHeader();
        FileHeader fileHeader = ntHeader.getFileHeader();
        OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
        SectionHeader[] sections = fileHeader.getSectionHeaders();
        if (sections.length == 0) {
            Msg.warn((Object)((Object)this), (Object)"No sections found");
        }
        int virtualSize = (int)Math.min((long)this.getVirtualSize(pe, sections, space), fileBytes.getSize());
        long addr = optionalHeader.getImageBase();
        Address address = space.getAddress(addr);
        this.adjustBlock(address, virtualSize, "Headers");
        try {
            for (int i = 0; i < sections.length; ++i) {
                int dataSize;
                if (monitor.isCancelled()) {
                    return sectionToAddress;
                }
                addr = (long)sections[i].getVirtualAddress() + optionalHeader.getImageBase();
                address = space.getAddress(addr);
                int rawDataSize = sections[i].getSizeOfRawData();
                int rawDataPtr = sections[i].getPointerToRawData();
                virtualSize = sections[i].getVirtualSize();
                if (rawDataSize != 0 && rawDataPtr != 0) {
                    int n = dataSize = rawDataSize > virtualSize && virtualSize > 0 || rawDataSize < 0 ? virtualSize : rawDataSize;
                    if (ntHeader.checkRVA((long)dataSize) || 0 < dataSize && (long)dataSize < pe.getFileLength()) {
                        Object sectionName;
                        if (!ntHeader.checkRVA((long)dataSize)) {
                            Msg.warn((Object)((Object)this), (Object)("OptionalHeader.SizeOfImage < size of " + sections[i].getName() + " section"));
                        }
                        if (((String)(sectionName = sections[i].getReadableName())).isBlank()) {
                            sectionName = "SECTION." + i;
                        }
                        sectionToAddress.put(sections[i], address);
                        this.adjustBlock(address, virtualSize, (String)sectionName);
                    }
                    if (rawDataSize == virtualSize || rawDataSize > virtualSize) continue;
                    if (rawDataSize < 0) {
                        Msg.error((Object)((Object)this), (Object)("Section[" + i + "] has invalid size " + Integer.toHexString(rawDataSize) + " (" + Integer.toHexString(virtualSize) + ")"));
                        break;
                    }
                    virtualSize -= rawDataSize;
                    address = address.add((long)rawDataSize);
                }
                if (virtualSize == 0) {
                    Msg.error((Object)((Object)this), (Object)("Section[" + i + "] has size zero"));
                    continue;
                }
                int n = dataSize = virtualSize > 0 || rawDataSize < 0 ? virtualSize : 0;
                if (dataSize <= 0) continue;
                sectionToAddress.put(sections[i], address);
                this.adjustBlock(address, virtualSize, sections[i].getReadableName());
            }
        }
        catch (IllegalStateException ise) {
            if (optionalHeader.getFileAlignment() != optionalHeader.getSectionAlignment()) {
                throw new IllegalStateException(ise);
            }
            Msg.warn((Object)((Object)this), (Object)"Section header processing aborted");
        }
        return sectionToAddress;
    }

    protected void addExternalReference(Data pointerData, ImportInfo importInfo, MessageLog log) {
    }
}

