/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

class ExtEntryPointXmlMgr {
    private MessageLog log;
    private AddressFactory factory;
    private SymbolTable symbolTable;

    ExtEntryPointXmlMgr(Program program, MessageLog log) {
        this.log = log;
        this.symbolTable = program.getSymbolTable();
        this.factory = program.getAddressFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void read(XmlPullParser parser, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        XmlElement element = parser.next();
        while (true) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            element = parser.peek();
            if (!element.getName().equals("PROGRAM_ENTRY_POINT")) {
                element = parser.next();
                return;
            }
            element = parser.next();
            String addrStr = element.getAttribute("ADDRESS");
            Address addr = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)addrStr);
            if (addr == null) {
                throw new AddressFormatException("Incompatible Entry Point Address: " + addrStr);
            }
            try {
                this.symbolTable.addExternalEntryPoint(addr);
                continue;
            }
            catch (Exception e) {
                this.log.appendException((Throwable)e);
                continue;
            }
            finally {
                element = parser.next();
                continue;
            }
            break;
        }
    }

    void write(XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Getting ENTRY POINTS ...");
        writer.startElement("PROGRAM_ENTRY_POINTS");
        AddressIterator iter = this.symbolTable.getExternalEntryPointIterator();
        ArrayList<Address> list = new ArrayList<Address>();
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            list.add(iter.next());
        }
        monitor.setMessage("Sorting ENTRY POINTS ...");
        Collections.sort(list);
        monitor.setMessage("Writing ENTRY POINTS ...");
        Iterator listIter = list.iterator();
        while (listIter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Address addr = (Address)listIter.next();
            if (set != null && !set.contains(addr)) continue;
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("ADDRESS", addr.toString());
            writer.startElement("PROGRAM_ENTRY_POINT", attrs);
            writer.endElement("PROGRAM_ENTRY_POINT");
        }
        writer.endElement("PROGRAM_ENTRY_POINTS");
    }
}

