/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractParsableItem;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class LocalVariableFlags
extends AbstractParsableItem {
    private int flags;
    private boolean isParameter;
    private boolean addressTaken;
    private boolean compilerGenerated;
    private boolean isAggregateWhole;
    private boolean isAggregatedPart;
    private boolean isAliased;
    private boolean isAlias;
    private boolean isFunctionReturnValue;
    private boolean isOptimizedOut;
    private boolean isEnregisteredGlobal;
    private boolean isEnregisteredStatic;

    public LocalVariableFlags(PdbByteReader reader) throws PdbException {
        this.flags = reader.parseUnsignedShortVal();
        this.processFlags(this.flags);
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.insert(0, this.isParameter ? "Param: " : "Local: ");
        DelimiterState ds = new DelimiterState(" ", ", ");
        builder.append(ds.out(this.addressTaken, "Address Taken"));
        builder.append(ds.out(this.compilerGenerated, "Compiler Generated"));
        builder.append(ds.out(this.isAggregateWhole, "aggregate"));
        builder.append(ds.out(this.isAggregatedPart, "aggregated"));
        builder.append(ds.out(this.isAliased, "aliased"));
        builder.append(ds.out(this.isAlias, "alias"));
        builder.append(ds.out(this.isFunctionReturnValue, "return value"));
        builder.append(ds.out(this.isOptimizedOut, "optimized away"));
        if (this.isEnregisteredGlobal) {
            if (this.isEnregisteredStatic) {
                builder.append(ds.out(true, "file static"));
            } else {
                builder.append(ds.out(true, "global"));
            }
        } else if (this.isEnregisteredStatic) {
            builder.append(ds.out(true, "static local"));
        }
    }

    private void processFlags(int val) {
        this.isParameter = (val & 1) == 1;
        this.addressTaken = ((val >>= 1) & 1) == 1;
        this.compilerGenerated = ((val >>= 1) & 1) == 1;
        this.isAggregateWhole = ((val >>= 1) & 1) == 1;
        this.isAggregatedPart = ((val >>= 1) & 1) == 1;
        this.isAliased = ((val >>= 1) & 1) == 1;
        this.isAlias = ((val >>= 1) & 1) == 1;
        this.isFunctionReturnValue = ((val >>= 1) & 1) == 1;
        this.isOptimizedOut = ((val >>= 1) & 1) == 1;
        this.isEnregisteredGlobal = ((val >>= 1) & 1) == 1;
        this.isEnregisteredStatic = ((val >>= 1) & 1) == 1;
    }
}

