/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.pdb.pdbapplicator.BlockCommentsManager;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.program.model.address.Address;

public class BlockNestingContext {
    private static final String BLOCK_INDENT = "   ";
    private DefaultPdbApplicator applicator;
    private BlockCommentsManager comments;
    private int nestingLevel;
    private Address currentBlockAddress;

    public BlockNestingContext(DefaultPdbApplicator applicator) {
        this.applicator = applicator;
        this.nestingLevel = 0;
        this.comments = new BlockCommentsManager();
    }

    public boolean notDone() {
        return this.nestingLevel > 0;
    }

    public Address getCurrentBlockAddress() {
        return this.currentBlockAddress;
    }

    public BlockCommentsManager getComments() {
        return this.comments;
    }

    public int endBlock() {
        if (--this.nestingLevel < 0) {
            this.applicator.appendLogMsg("Block Nesting went negative for ending block that began at " + String.valueOf(this.currentBlockAddress));
        }
        if (this.nestingLevel == 0) {
            // empty if block
        }
        return this.nestingLevel;
    }

    public int getLevel() {
        return this.nestingLevel;
    }

    public void beginBlock(Address startAddress, String name, long length) {
        ++this.nestingLevel;
        this.currentBlockAddress = startAddress;
        if (!this.applicator.getPdbApplicatorOptions().applyCodeScopeBlockComments()) {
            return;
        }
        if (this.applicator.isInvalidAddress(startAddress, name)) {
            return;
        }
        String indent = this.getIndent(this.nestingLevel);
        String baseComment = "level " + this.nestingLevel + ", length " + length;
        String preComment = indent + "PDB: Block Beg, " + baseComment;
        if (name != null && !name.isEmpty()) {
            preComment = preComment + " (" + name + ")";
        }
        this.comments.addPreComment(startAddress, preComment);
        String postComment = indent + "PDB: Block End, " + baseComment;
        Address endAddress = startAddress.add(length <= 0L ? 0L : length - 1L);
        this.comments.addPostComment(endAddress, postComment);
    }

    public String getIndent(int indentLevel) {
        return BLOCK_INDENT.repeat(indentLevel);
    }
}

