/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.AbstractPointerTypedefBuiltIn;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.PointerType;
import ghidra.program.model.data.PointerTypeSettingsDefinition;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.util.classfinder.ClassTranslator;

public class IBO32DataType
extends AbstractPointerTypedefBuiltIn {
    public static final IBO32DataType dataType = new IBO32DataType();
    static final String NAME = "ImageBaseOffset32";
    private static TypeDefSettingsDefinition[] IBO_TYPEDEF_SETTINGS_DEFS = new TypeDefSettingsDefinition[]{PointerTypeSettingsDefinition.DEF};

    public IBO32DataType() {
        this(null);
    }

    public IBO32DataType(DataTypeManager dtm) {
        super(NAME, null, 4, dtm);
        PointerTypeSettingsDefinition.DEF.setType(this.getDefaultSettings(), PointerType.IMAGE_BASE_RELATIVE);
    }

    @Override
    public String getDescription() {
        return "32-bit Image Base Offset Relative Pointer-Typedef";
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (this.dataMgr == dtm) {
            return this;
        }
        return new IBO32DataType(dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "ibo32";
    }

    public TypeDefSettingsDefinition[] getBuiltInSettingsDefinitions() {
        return IBO_TYPEDEF_SETTINGS_DEFS;
    }

    public static PointerTypedef createIBO32PointerTypedef(DataType referencedDataType) {
        return new PointerTypedef(null, referencedDataType, 4, referencedDataType != null ? referencedDataType.getDataTypeManager() : null, PointerType.IMAGE_BASE_RELATIVE);
    }

    static {
        ClassTranslator.put((String)"ghidra.program.model.data.ImageBaseOffset32", (String)IBO32DataType.class.getName());
        ClassTranslator.put((String)"ghidra.program.model.data.ImageBaseOffset32DataType", (String)IBO32DataType.class.getName());
    }
}

