/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.util.ProgramMergeFilter;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;

class DiffApplySettingsOptionManager {
    public static final String DIFF_OPTIONS = "Diff";
    public static final String DIFF_APPLY_SETTINGS_OPTIONS = "Default Apply Settings";
    private static final int PROGRAM_CONTEXT = 1;
    private static final int BYTES = 2;
    private static final int CODE_UNITS = 4;
    private static final int REFERENCES = 8;
    private static final int PLATE_COMMENTS = 16;
    private static final int PRE_COMMENTS = 32;
    private static final int EOL_COMMENTS = 64;
    private static final int REPEATABLE_COMMENTS = 128;
    private static final int POST_COMMENTS = 256;
    private static final int SYMBOLS = 512;
    private static final int BOOKMARKS = 1024;
    private static final int PROPERTIES = 2048;
    private static final int FUNCTIONS = 4096;
    private static final int FUNCTION_TAGS = 8192;
    private static final int SOURCE_MAP = 16384;
    private static final String OPTION_PROGRAM_CONTEXT = "Default Apply Settings.Program Context";
    private static final String OPTION_BYTES = "Default Apply Settings.Bytes";
    private static final String OPTION_CODE_UNITS = "Default Apply Settings.Code Units";
    private static final String OPTION_REFERENCES = "Default Apply Settings.References";
    private static final String OPTION_PLATE_COMMENTS = "Default Apply Settings.Plate Comments";
    private static final String OPTION_PRE_COMMENTS = "Default Apply Settings.Pre Comments";
    private static final String OPTION_EOL_COMMENTS = "Default Apply Settings.End Of Line Comments";
    private static final String OPTION_REPEATABLE_COMMENTS = "Default Apply Settings.Repeatable Comments";
    private static final String OPTION_POST_COMMENTS = "Default Apply Settings.Post Comments";
    private static final String OPTION_SYMBOLS = "Default Apply Settings.Labels";
    private static final String OPTION_BOOKMARKS = "Default Apply Settings.Bookmarks";
    private static final String OPTION_PROPERTIES = "Default Apply Settings.Properties";
    private static final String OPTION_FUNCTIONS = "Default Apply Settings.Functions";
    private static final String OPTION_FUNCTION_TAGS = "Default Apply Settings.Function Tags";
    private static final String OPTION_SOURCE_MAP = "Default Apply Settings.Source Map";
    private Plugin plugin;
    private HelpLocation help;
    private String HELP_TOPIC = "Diff";

    DiffApplySettingsOptionManager(Plugin plugin) {
        this.plugin = plugin;
        this.init();
    }

    private void init() {
        this.help = new HelpLocation(this.HELP_TOPIC, "DiffApplySettingsToolOptions");
        ToolOptions options = this.plugin.getTool().getOptions(DIFF_OPTIONS);
        options.setOptionsHelpLocation(this.help);
        options.registerOption(OPTION_PROGRAM_CONTEXT, (Object)REPLACE_CHOICE.REPLACE, this.help, this.getReplaceDescription("program context register value", "program context register values"));
        options.registerOption(OPTION_BYTES, (Object)REPLACE_CHOICE.REPLACE, this.help, this.getReplaceDescription("byte", "bytes"));
        options.registerOption(OPTION_CODE_UNITS, (Object)REPLACE_CHOICE.REPLACE, this.help, this.getReplaceDescription("code unit", "code units"));
        options.registerOption(OPTION_REFERENCES, (Object)REPLACE_CHOICE.REPLACE, this.help, this.getReplaceDescription("reference", "references"));
        options.registerOption(OPTION_PLATE_COMMENTS, (Object)MERGE_CHOICE.MERGE, this.help, this.getMergeDescription("plate comment", "plate comments"));
        options.registerOption(OPTION_PRE_COMMENTS, (Object)MERGE_CHOICE.MERGE, this.help, this.getMergeDescription("pre-comment", "pre-comments"));
        options.registerOption(OPTION_EOL_COMMENTS, (Object)MERGE_CHOICE.MERGE, this.help, this.getMergeDescription("end of line comment", "end of line comments"));
        options.registerOption(OPTION_REPEATABLE_COMMENTS, (Object)MERGE_CHOICE.MERGE, this.help, this.getMergeDescription("repeatable comment", "repeatable comments"));
        options.registerOption(OPTION_POST_COMMENTS, (Object)MERGE_CHOICE.MERGE, this.help, this.getMergeDescription("post comment", "post comments"));
        options.registerOption(OPTION_SYMBOLS, (Object)SYMBOL_MERGE_CHOICE.MERGE_AND_SET_PRIMARY, this.help, this.getSymbolDescription());
        options.registerOption(OPTION_BOOKMARKS, (Object)REPLACE_CHOICE.REPLACE, this.help, this.getReplaceDescription("bookmark", "bookmarks"));
        options.registerOption(OPTION_PROPERTIES, (Object)REPLACE_CHOICE.REPLACE, this.help, this.getReplaceDescription("property", "properties"));
        options.registerOption(OPTION_FUNCTIONS, (Object)REPLACE_CHOICE.REPLACE, this.help, this.getReplaceDescription("function", "functions"));
        options.registerOption(OPTION_FUNCTION_TAGS, (Object)MERGE_CHOICE.MERGE, this.help, this.getReplaceDescription("function tag", "function tags"));
        options.registerOption(OPTION_SOURCE_MAP, (Object)REPLACE_CHOICE.IGNORE, this.help, this.getReplaceDescription("source map", "source map"));
        this.getDefaultApplyFilter();
    }

    public ProgramMergeFilter getDefaultApplyFilter() {
        PluginTool tool = this.plugin.getTool();
        ToolOptions options = tool.getOptions(DIFF_OPTIONS);
        REPLACE_CHOICE programContext = (REPLACE_CHOICE)options.getEnum(OPTION_PROGRAM_CONTEXT, (Enum)REPLACE_CHOICE.REPLACE);
        REPLACE_CHOICE bytes = (REPLACE_CHOICE)options.getEnum(OPTION_BYTES, (Enum)REPLACE_CHOICE.REPLACE);
        REPLACE_CHOICE codeUnits = (REPLACE_CHOICE)options.getEnum(OPTION_CODE_UNITS, (Enum)REPLACE_CHOICE.REPLACE);
        REPLACE_CHOICE references = (REPLACE_CHOICE)options.getEnum(OPTION_REFERENCES, (Enum)REPLACE_CHOICE.REPLACE);
        MERGE_CHOICE plateComments = (MERGE_CHOICE)options.getEnum(OPTION_PLATE_COMMENTS, (Enum)MERGE_CHOICE.MERGE);
        MERGE_CHOICE preComments = (MERGE_CHOICE)options.getEnum(OPTION_PRE_COMMENTS, (Enum)MERGE_CHOICE.MERGE);
        MERGE_CHOICE eolComments = (MERGE_CHOICE)options.getEnum(OPTION_EOL_COMMENTS, (Enum)MERGE_CHOICE.MERGE);
        MERGE_CHOICE repeatableComments = (MERGE_CHOICE)options.getEnum(OPTION_REPEATABLE_COMMENTS, (Enum)MERGE_CHOICE.MERGE);
        MERGE_CHOICE postComments = (MERGE_CHOICE)options.getEnum(OPTION_POST_COMMENTS, (Enum)MERGE_CHOICE.MERGE);
        SYMBOL_MERGE_CHOICE symbols = (SYMBOL_MERGE_CHOICE)options.getEnum(OPTION_SYMBOLS, (Enum)SYMBOL_MERGE_CHOICE.MERGE_AND_SET_PRIMARY);
        REPLACE_CHOICE bookmarks = (REPLACE_CHOICE)options.getEnum(OPTION_BOOKMARKS, (Enum)REPLACE_CHOICE.REPLACE);
        REPLACE_CHOICE properties = (REPLACE_CHOICE)options.getEnum(OPTION_PROPERTIES, (Enum)REPLACE_CHOICE.REPLACE);
        REPLACE_CHOICE functions = (REPLACE_CHOICE)options.getEnum(OPTION_FUNCTIONS, (Enum)REPLACE_CHOICE.REPLACE);
        MERGE_CHOICE functionTags = (MERGE_CHOICE)options.getEnum(OPTION_FUNCTION_TAGS, (Enum)MERGE_CHOICE.MERGE);
        REPLACE_CHOICE sourceMap = (REPLACE_CHOICE)options.getEnum(OPTION_SOURCE_MAP, (Enum)REPLACE_CHOICE.IGNORE);
        ProgramMergeFilter filter = new ProgramMergeFilter();
        filter.setFilter(1, programContext.ordinal());
        filter.setFilter(2, bytes.ordinal());
        filter.setFilter(12, codeUnits.ordinal());
        filter.setFilter(16, references.ordinal());
        filter.setFilter(32, plateComments.ordinal());
        filter.setFilter(64, preComments.ordinal());
        filter.setFilter(128, eolComments.ordinal());
        filter.setFilter(256, repeatableComments.ordinal());
        filter.setFilter(512, postComments.ordinal());
        filter.setFilter(1024, this.convertSymbolMergeChoiceToMergeChoice(symbols).ordinal());
        filter.setFilter(2048, bookmarks.ordinal());
        filter.setFilter(4096, properties.ordinal());
        filter.setFilter(8192, functions.ordinal());
        filter.setFilter(65536, functionTags.ordinal());
        filter.setFilter(32768, this.convertSymbolMergeChoiceToReplaceChoiceForPrimay(symbols).ordinal());
        filter.setFilter(131072, sourceMap.ordinal());
        return filter;
    }

    private String getReplaceDescription(String settingName, String pluralName) {
        return this.getBaseDescription(settingName) + "\n" + this.getIgnoreDescription(settingName) + "\n" + this.getReplaceDescription(pluralName);
    }

    private String getMergeDescription(String settingName, String pluralName) {
        return this.getBaseDescription(settingName) + "\n" + this.getIgnoreDescription(settingName) + "\n" + this.getReplaceDescription(pluralName) + "\n" + this.getMergeDescription(pluralName);
    }

    private String getBaseDescription(String settingName) {
        return "The default Diff setting for applying " + settingName + " differences.";
    }

    private String getIgnoreDescription(String settingName) {
        return " Ignore - Don't apply " + settingName + " differences.";
    }

    private String getReplaceDescription(String pluralName) {
        return " Replace - Replace " + pluralName + " in the program with those from program 2.";
    }

    private String getMergeDescription(String pluralName) {
        return " Merge - Merge " + pluralName + " from program 2 into the current program.";
    }

    private String getSymbolDescription() {
        String settingName = "label";
        String pluralName = "labels";
        return this.getBaseDescription(settingName) + "\n" + this.getIgnoreDescription(settingName) + "\n" + this.getReplaceDescription(pluralName) + "\n Merge - Merge " + pluralName + " from program 2 into the current program and don't change which " + settingName + " is primary.\n Merge & Set Primary - Merge " + pluralName + " from program 2 into the current program and set the primary " + settingName + " as it is in program 2, if possible.";
    }

    public void saveDefaultApplyFilter(ProgramMergeFilter newDefaultApplyFilter) {
        PluginTool tool = this.plugin.getTool();
        ToolOptions options = tool.getOptions(DIFF_OPTIONS);
        this.saveReplaceOption((Options)options, newDefaultApplyFilter, 1);
        this.saveReplaceOption((Options)options, newDefaultApplyFilter, 2);
        this.saveReplaceOption((Options)options, newDefaultApplyFilter, 8);
        this.saveReplaceOption((Options)options, newDefaultApplyFilter, 1024);
        this.saveReplaceOption((Options)options, newDefaultApplyFilter, 2048);
        this.saveReplaceOption((Options)options, newDefaultApplyFilter, 4096);
        this.saveReplaceOption((Options)options, newDefaultApplyFilter, 16384);
        this.saveMergeOption((Options)options, newDefaultApplyFilter, 16);
        this.saveMergeOption((Options)options, newDefaultApplyFilter, 32);
        this.saveMergeOption((Options)options, newDefaultApplyFilter, 64);
        this.saveMergeOption((Options)options, newDefaultApplyFilter, 128);
        this.saveMergeOption((Options)options, newDefaultApplyFilter, 256);
        this.saveMergeOption((Options)options, newDefaultApplyFilter, 8192);
        this.saveCodeUnitReplaceOption((Options)options, newDefaultApplyFilter, 4);
        this.saveSymbolMergeOption((Options)options, newDefaultApplyFilter, 512);
        tool.setConfigChanged(true);
    }

    private void saveCodeUnitReplaceOption(Options options, ProgramMergeFilter defaultApplyFilter, int setting) {
        int filter = defaultApplyFilter.getFilter(4) >= defaultApplyFilter.getFilter(8) ? 4 : 8;
        REPLACE_CHOICE defaultSetting = REPLACE_CHOICE.REPLACE;
        REPLACE_CHOICE optionSetting = (REPLACE_CHOICE)options.getEnum(this.getOptionName(setting), (Enum)defaultSetting);
        REPLACE_CHOICE diffSetting = this.convertTypeToReplaceEnum(defaultApplyFilter, filter);
        if (!diffSetting.equals((Object)optionSetting)) {
            options.setEnum(this.getOptionName(setting), (Enum)diffSetting);
        }
    }

    private void saveReplaceOption(Options options, ProgramMergeFilter defaultApplyFilter, int setting) {
        REPLACE_CHOICE defaultSetting = REPLACE_CHOICE.REPLACE;
        REPLACE_CHOICE optionSetting = (REPLACE_CHOICE)options.getEnum(this.getOptionName(setting), (Enum)defaultSetting);
        REPLACE_CHOICE diffSetting = this.convertTypeToReplaceEnum(defaultApplyFilter, this.getMergeFilterType(setting));
        if (!diffSetting.equals((Object)optionSetting)) {
            options.setEnum(this.getOptionName(setting), (Enum)diffSetting);
        }
    }

    private void saveMergeOption(Options options, ProgramMergeFilter defaultApplyFilter, int setting) {
        MERGE_CHOICE defaultSetting = MERGE_CHOICE.MERGE;
        MERGE_CHOICE optionSetting = (MERGE_CHOICE)options.getEnum(this.getOptionName(setting), (Enum)defaultSetting);
        MERGE_CHOICE diffSetting = this.convertTypeToMergeEnum(defaultApplyFilter, this.getMergeFilterType(setting));
        if (!diffSetting.equals((Object)optionSetting)) {
            options.setEnum(this.getOptionName(setting), (Enum)diffSetting);
        }
    }

    private void saveSymbolMergeOption(Options options, ProgramMergeFilter defaultApplyFilter, int setting) {
        SYMBOL_MERGE_CHOICE defaultSetting = SYMBOL_MERGE_CHOICE.MERGE_AND_SET_PRIMARY;
        SYMBOL_MERGE_CHOICE optionSetting = (SYMBOL_MERGE_CHOICE)options.getEnum(this.getOptionName(setting), (Enum)defaultSetting);
        SYMBOL_MERGE_CHOICE diffSetting = this.getSymbolMergeEnum(defaultApplyFilter);
        if (!diffSetting.equals((Object)optionSetting)) {
            options.setEnum(this.getOptionName(setting), (Enum)diffSetting);
        }
    }

    private int getMergeFilterType(int applySetting) {
        switch (applySetting) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 12;
            }
            case 8: {
                return 16;
            }
            case 1024: {
                return 2048;
            }
            case 2048: {
                return 4096;
            }
            case 4096: {
                return 8192;
            }
            case 16: {
                return 32;
            }
            case 32: {
                return 64;
            }
            case 64: {
                return 128;
            }
            case 128: {
                return 256;
            }
            case 256: {
                return 512;
            }
            case 512: {
                return 1024;
            }
            case 8192: {
                return 65536;
            }
            case 16384: {
                return 131072;
            }
        }
        return 0;
    }

    private String getOptionName(int applySetting) {
        switch (applySetting) {
            case 1: {
                return OPTION_PROGRAM_CONTEXT;
            }
            case 2: {
                return OPTION_BYTES;
            }
            case 4: {
                return OPTION_CODE_UNITS;
            }
            case 8: {
                return OPTION_REFERENCES;
            }
            case 1024: {
                return OPTION_BOOKMARKS;
            }
            case 2048: {
                return OPTION_PROPERTIES;
            }
            case 4096: {
                return OPTION_FUNCTIONS;
            }
            case 16: {
                return OPTION_PLATE_COMMENTS;
            }
            case 32: {
                return OPTION_PRE_COMMENTS;
            }
            case 64: {
                return OPTION_EOL_COMMENTS;
            }
            case 128: {
                return OPTION_REPEATABLE_COMMENTS;
            }
            case 256: {
                return OPTION_POST_COMMENTS;
            }
            case 512: {
                return OPTION_SYMBOLS;
            }
            case 8192: {
                return OPTION_FUNCTION_TAGS;
            }
            case 16384: {
                return OPTION_SOURCE_MAP;
            }
        }
        return null;
    }

    MERGE_CHOICE convertSymbolMergeChoiceToMergeChoice(SYMBOL_MERGE_CHOICE symbolMergeChoice) {
        switch (symbolMergeChoice.ordinal()) {
            default: {
                return MERGE_CHOICE.IGNORE;
            }
            case 1: {
                return MERGE_CHOICE.REPLACE;
            }
            case 2: 
            case 3: 
        }
        return MERGE_CHOICE.MERGE;
    }

    REPLACE_CHOICE convertSymbolMergeChoiceToReplaceChoiceForPrimay(SYMBOL_MERGE_CHOICE symbolMergeChoice) {
        switch (symbolMergeChoice.ordinal()) {
            default: {
                return REPLACE_CHOICE.IGNORE;
            }
            case 1: 
            case 3: 
        }
        return REPLACE_CHOICE.REPLACE;
    }

    int convertFiltersToSymbolIndex(int symbolFilter, int primaryFilter) {
        switch (symbolFilter) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
        }
        if (primaryFilter == 1) {
            return 3;
        }
        return 2;
    }

    private REPLACE_CHOICE convertTypeToReplaceEnum(ProgramMergeFilter defaultApplyFilter, int type) {
        int filter = defaultApplyFilter.getFilter(type);
        Msg.info((Object)this, (Object)("type: " + Integer.toHexString(filter) + " filter: " + filter));
        return REPLACE_CHOICE.values()[filter];
    }

    private MERGE_CHOICE convertTypeToMergeEnum(ProgramMergeFilter defaultApplyFilter, int type) {
        int filter = defaultApplyFilter.getFilter(type);
        return MERGE_CHOICE.values()[filter];
    }

    private SYMBOL_MERGE_CHOICE getSymbolMergeEnum(ProgramMergeFilter defaultApplyFilter) {
        int symbolsFilter = defaultApplyFilter.getFilter(1024);
        int primarySymbolFilter = defaultApplyFilter.getFilter(32768);
        int filter = this.convertFiltersToSymbolIndex(symbolsFilter, primarySymbolFilter);
        return SYMBOL_MERGE_CHOICE.values()[filter];
    }

    public void dispose() {
    }

    public static enum REPLACE_CHOICE {
        IGNORE("Ignore"),
        REPLACE("Replace");

        private String description;

        private REPLACE_CHOICE(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum MERGE_CHOICE {
        IGNORE("Ignore"),
        REPLACE("Replace"),
        MERGE("Merge");

        private String description;

        private MERGE_CHOICE(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum SYMBOL_MERGE_CHOICE {
        IGNORE("Ignore"),
        REPLACE("Replace"),
        MERGE_DONT_SET_PRIMARY("Merge"),
        MERGE_AND_SET_PRIMARY("Merge & Set Primary");

        private String description;

        private SYMBOL_MERGE_CHOICE(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

