/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RemoveRequireNotNullCallFix;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacadeKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J,\u0010\n\u001a\u00020\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantRequireNotNullCallInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isNullable", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nRedundantRequireNotNullCallInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantRequireNotNullCallInspection.kt\norg/jetbrains/kotlin/idea/inspections/RedundantRequireNotNullCallInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n2746#2,3:89\n*S KotlinDebug\n*F\n+ 1 RedundantRequireNotNullCallInspection.kt\norg/jetbrains/kotlin/idea/inspections/RedundantRequireNotNullCallInspection\n*L\n69#1:89,3\n*E\n"})
public final class RedundantRequireNotNullCallInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return VisitorWrappersKt.callExpressionVisitor(arg_0 -> RedundantRequireNotNullCallInspection.buildVisitor$lambda$0(this, holder2, arg_0));
    }

    private final boolean isNullable(KtReferenceExpression $this$isNullable, CallableDescriptor descriptor2, KotlinType type2, BindingContext context, ResolutionFacade resolutionFacade) {
        boolean bl;
        block4: {
            if (!KotlinTypeKt.isNullable((KotlinType)type2)) {
                return false;
            }
            DataFlowValueFactory dataFlowValueFactory = ResolutionFacadeKt.getDataFlowValueFactory(resolutionFacade);
            DataFlowValue dataFlow = dataFlowValueFactory.createDataFlowValue((KtExpression)$this$isNullable, type2, context, (DeclarationDescriptor)descriptor2);
            Set stableTypes = BindingContextUtilsKt.getDataFlowInfoBefore((BindingContext)context, (PsiElement)((PsiElement)$this$isNullable)).getStableTypes(dataFlow, LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)$this$isNullable));
            Iterable $this$none$iv = stableTypes;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!(!KotlinTypeKt.isNullable((KotlinType)it))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final Unit buildVisitor$lambda$0(RedundantRequireNotNullCallInspection this$0, ProblemsHolder $holder, KtCallExpression callExpression) {
        KtExpression ktExpression = callExpression.getCalleeExpression();
        if (ktExpression == null) {
            return Unit.INSTANCE;
        }
        KtExpression callee = ktExpression;
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade((KtElement)callExpression);
        BindingContext context = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)callExpression, resolutionFacade, BodyResolveMode.PARTIAL);
        if (!FunctionUtilsKt.isCalling(callExpression, new FqName("kotlin.requireNotNull"), context) && !FunctionUtilsKt.isCalling(callExpression, new FqName("kotlin.checkNotNull"), context)) {
            return Unit.INSTANCE;
        }
        List list2 = callExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
        KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull((List)list2);
        if (ktValueArgument == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null || (ktValueArgument = KtPsiUtilKt.referenceExpression((KtExpression)ktValueArgument)) == null) {
            return Unit.INSTANCE;
        }
        KtValueArgument argument2 = ktValueArgument;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)argument2), (BindingContext)context);
        if (resolvedCall == null || (resolvedCall = resolvedCall.getResultingDescriptor()) == null) {
            return Unit.INSTANCE;
        }
        ResolvedCall descriptor2 = resolvedCall;
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return Unit.INSTANCE;
        }
        KotlinType type2 = kotlinType;
        if (this$0.isNullable((KtReferenceExpression)argument2, (CallableDescriptor)descriptor2, type2, context, resolutionFacade)) {
            return Unit.INSTANCE;
        }
        String functionName = callee.getText();
        PsiElement psiElement = (PsiElement)callee;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)functionName);
        objectArray[0] = functionName;
        String string = KotlinBundle.message((String)"redundant.0.call", (Object[])objectArray);
        objectArray = new LocalQuickFix[]{new RemoveRequireNotNullCallFix(functionName)};
        $holder.registerProblem(psiElement, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
        return Unit.INSTANCE;
    }
}

