/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.impl.projectlevelman.OptionsAndConfirmations;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ProjectLevelVcsManagerSerialization {
    @NonNls
    private static final String OPTIONS_SETTING = "OptionsSetting";
    @NonNls
    private static final String CONFIRMATIONS_SETTING = "ConfirmationsSetting";
    @NonNls
    private static final String VALUE_ATTTIBUTE = "value";
    @NonNls
    private static final String ID_ATTRIBUTE = "id";

    public static void readExternalUtil(@NotNull Element element, @NotNull OptionsAndConfirmations optionsAndConfirmations) throws InvalidDataException {
        String value;
        String id;
        if (element == null) {
            ProjectLevelVcsManagerSerialization.$$$reportNull$$$0(0);
        }
        if (optionsAndConfirmations == null) {
            ProjectLevelVcsManagerSerialization.$$$reportNull$$$0(1);
        }
        for (Element subElement : element.getChildren(OPTIONS_SETTING)) {
            id = subElement.getAttributeValue(ID_ATTRIBUTE);
            value = subElement.getAttributeValue(VALUE_ATTTIBUTE);
            if (id == null || value == null) continue;
            optionsAndConfirmations.setOptionValue(id, Boolean.parseBoolean(value));
        }
        for (Element subElement : element.getChildren(CONFIRMATIONS_SETTING)) {
            id = subElement.getAttributeValue(ID_ATTRIBUTE);
            value = subElement.getAttributeValue(VALUE_ATTTIBUTE);
            if (id == null || value == null) continue;
            optionsAndConfirmations.setConfirmationValue(id, VcsShowConfirmationOption.Value.fromString((String)value));
        }
    }

    public static void writeExternalUtil(@NotNull Element element, @NotNull OptionsAndConfirmations optionsAndConfirmations) throws WriteExternalException {
        if (element == null) {
            ProjectLevelVcsManagerSerialization.$$$reportNull$$$0(2);
        }
        if (optionsAndConfirmations == null) {
            ProjectLevelVcsManagerSerialization.$$$reportNull$$$0(3);
        }
        optionsAndConfirmations.getOptionsValues().forEach((id, value) -> {
            if (!value.booleanValue()) {
                Element settingElement = new Element(OPTIONS_SETTING);
                element.addContent(settingElement);
                settingElement.setAttribute(VALUE_ATTTIBUTE, Boolean.toString(value));
                settingElement.setAttribute(ID_ATTRIBUTE, id);
            }
        });
        optionsAndConfirmations.getConfirmationsValues().forEach((id, value) -> {
            if (value != VcsShowConfirmationOption.Value.SHOW_CONFIRMATION) {
                Element settingElement = new Element(CONFIRMATIONS_SETTING);
                element.addContent(settingElement);
                settingElement.setAttribute(VALUE_ATTTIBUTE, value.toString());
                settingElement.setAttribute(ID_ATTRIBUTE, id);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsAndConfirmations";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/ProjectLevelVcsManagerSerialization";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternalUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternalUtil";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

