/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.OptionalLong;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.OptionalShouldBeEmpty;
import org.assertj.core.error.OptionalShouldBePresent;
import org.assertj.core.error.OptionalShouldContain;
import org.assertj.core.internal.Failures;

public abstract class AbstractOptionalLongAssert<SELF extends AbstractOptionalLongAssert<SELF>>
extends AbstractAssert<SELF, OptionalLong> {
    protected AbstractOptionalLongAssert(OptionalLong actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isPresent() {
        this.isNotNull();
        if (!((OptionalLong)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBePresent.shouldBePresent(this.actual));
        }
        return (SELF)((AbstractOptionalLongAssert)this.myself);
    }

    public SELF isNotPresent() {
        return this.isEmpty();
    }

    public SELF isEmpty() {
        this.isNotNull();
        if (((OptionalLong)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldBeEmpty.shouldBeEmpty((OptionalLong)this.actual));
        }
        return (SELF)((AbstractOptionalLongAssert)this.myself);
    }

    public SELF isNotEmpty() {
        return this.isPresent();
    }

    public SELF hasValue(long expectedValue) {
        this.isNotNull();
        if (!((OptionalLong)this.actual).isPresent()) {
            this.throwAssertionError(OptionalShouldContain.shouldContain(expectedValue));
        }
        if (expectedValue != ((OptionalLong)this.actual).getAsLong()) {
            throw Failures.instance().failure(this.info, OptionalShouldContain.shouldContain((OptionalLong)this.actual, expectedValue), ((OptionalLong)this.actual).getAsLong(), expectedValue);
        }
        return (SELF)((AbstractOptionalLongAssert)this.myself);
    }
}

