/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.publisher;

import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.server.common.MetadataVersion;
import org.slf4j.Logger;

public class BrokerRegistrationTracker
implements MetadataPublisher {
    private final Logger log;
    private final int id;
    private final Runnable refreshRegistrationCallback;

    public BrokerRegistrationTracker(int id, Runnable refreshRegistrationCallback) {
        this.log = new LogContext("[BrokerRegistrationTracker id=" + id + "] ").logger(BrokerRegistrationTracker.class);
        this.id = id;
        this.refreshRegistrationCallback = refreshRegistrationCallback;
    }

    @Override
    public String name() {
        return "BrokerRegistrationTracker(id=" + this.id + ")";
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        boolean checkBrokerRegistration = false;
        if (delta.featuresDelta() != null && delta.metadataVersionChanged().isPresent()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Metadata version change is present: {}", delta.metadataVersionChanged());
            }
            checkBrokerRegistration = true;
        }
        if (delta.clusterDelta() != null && delta.clusterDelta().changedBrokers().get(this.id) != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Broker change is present: {}", delta.clusterDelta().changedBrokers().get(this.id));
            }
            checkBrokerRegistration = true;
        }
        if (checkBrokerRegistration && this.brokerRegistrationNeedsRefresh(newImage.features().metadataVersionOrThrow(), delta.clusterDelta().broker(this.id))) {
            this.refreshRegistrationCallback.run();
        }
    }

    boolean brokerRegistrationNeedsRefresh(MetadataVersion metadataVersion, BrokerRegistration registration) {
        if (registration == null) {
            this.log.debug("No current broker registration to check.");
            return false;
        }
        if (metadataVersion.isAtLeast(MetadataVersion.IBP_3_7_IV2) && registration.directories().isEmpty()) {
            this.log.info("Current directory set is empty, but MV supports JBOD. Resending broker registration.");
            return true;
        }
        this.log.debug("Broker registration does not need to be resent.");
        return false;
    }
}

