/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream64;
import com.dynatrace.hash4j.hashing.AbstractHasher64;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.UnsignedMultiplyUtil;

class PolymurHash2_0
implements AbstractHasher64 {
    private static final long POLYMUR_P611 = 0x1FFFFFFFFFFFFFFFL;
    private static final long POLYMUR_ARBITRARY1 = 7640891576956012808L;
    private static final long POLYMUR_ARBITRARY2 = -4942790177534073029L;
    private static final long POLYMUR_ARBITRARY3 = 4354685564936845355L;
    private static final long POLYMUR_ARBITRARY4 = -6534734903238641935L;
    private static final long[] POLYMUR_POW37 = PolymurHash2_0.calculatePolymurPow37();
    private final long k;
    private final long k2;
    private final long k3;
    private final long k3x;
    private final long k4;
    private final long k4x;
    private final long k5;
    private final long k6;
    private final long k7;
    private final long k14;
    private final long s;
    private final long tweak;

    static long[] calculatePolymurPow37() {
        return new long[]{37L, 1369L, 1874161L, 3512479453921L, 2048012909902302799L, 307828676072022436L, 1530484379699738889L, 1671968728696755707L, 649718369440752735L, 1874702330417107273L, 5986862548113618L, 1820568710247692212L, 404534779322076428L, 649492471404925175L, 1106896147619454396L, 1669740733653474757L, 1267668060077347163L, 1416360387298873781L, 1564471842796986341L, 735250336065844589L, 1488752000173493138L, 1320279768446765050L, 1747983813596511721L, 67869839423255989L, 2164827040180914092L, 1744025871715016688L, 73251981582425893L, 277374673314010419L, 92934223038987942L, 621132062226937276L, 552523982103027780L, 1810209022387899939L, 559096694736811184L, 711094314562858615L, 1622448854954581329L, 841055254665985916L, 697959595997859570L, 1808678955228361916L, 1904955967673210270L, 1826762296907946662L, 395654014531890260L, 1189103440328413580L, 1894874107849652993L, 302423639519868408L, 512544735919841438L, 994841178892020975L, 1365841398988935179L, 1389315537057605538L, 1620384436148347606L, 1236195944141684822L, 1927669204547316455L, 1367449615347781359L, 1879906979325824564L, 655204990766260670L, 617443249345278015L, 93335154568859392L, 1979613501565108617L, 1945635272481320524L, 331539492389086583L, 1344516579535654772L, 2305843009213693914L, 1369L, 1874161L, 3512479453921L};
    }

    static long[] calculatePolymurPow37Reference() {
        long[] POLYMUR_POW37 = new long[64];
        POLYMUR_POW37[0] = 37L;
        POLYMUR_POW37[32] = 559096694736811184L;
        for (int i = 0; i < 31; ++i) {
            POLYMUR_POW37[i + 1] = PolymurHash2_0.polymurExtrared611(PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(POLYMUR_POW37[i], POLYMUR_POW37[i]), POLYMUR_POW37[i] * POLYMUR_POW37[i]));
            POLYMUR_POW37[i + 33] = PolymurHash2_0.polymurExtrared611(PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(POLYMUR_POW37[i + 32], POLYMUR_POW37[i + 32]), POLYMUR_POW37[i + 32] * POLYMUR_POW37[i + 32]));
        }
        return POLYMUR_POW37;
    }

    private static long polymurExtrared611(long x) {
        return (x & 0x1FFFFFFFFFFFFFFFL) + (x >>> 61);
    }

    private static long polymurMix(long x) {
        x ^= x >>> 32;
        x *= 1051668233026429277L;
        x ^= x >>> 32;
        x *= 1051668233026429277L;
        x ^= x >>> 28;
        return x;
    }

    private static long polymurRed611(long xhi, long xlo) {
        return (xlo & 0x1FFFFFFFFFFFFFFFL) + (xlo >>> 61 | xhi << 3);
    }

    public static Hasher64 create(long tweak, long kSeed, long sSeed) {
        return new PolymurHash2_0(tweak, kSeed, sSeed);
    }

    private PolymurHash2_0(long tweak, long kSeed, long sSeed) {
        long k7Tmp;
        long k2Tmp;
        long kTmp;
        while (true) {
            long k4Tmp;
            long e;
            if ((e = (kSeed += -4942790177534073029L) >>> 3 | 1L) % 3L == 0L || e % 5L == 0L || e % 7L == 0L || e % 11L == 0L || e % 13L == 0L || e % 31L == 0L || e % 41L == 0L || e % 61L == 0L || e % 151L == 0L || e % 331L == 0L || e % 1321L == 0L) {
                continue;
            }
            long ka = 1L;
            long kb = 1L;
            int i = 0;
            while (e != 0L) {
                long pp37;
                if ((e & 1L) != 0L) {
                    pp37 = POLYMUR_POW37[i];
                    ka = PolymurHash2_0.polymurExtrared611(PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(ka, pp37), ka * pp37));
                }
                if ((e & 2L) != 0L) {
                    pp37 = POLYMUR_POW37[i + 1];
                    kb = PolymurHash2_0.polymurExtrared611(PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(kb, pp37), kb * pp37));
                }
                i += 2;
                e >>>= 2;
            }
            kTmp = PolymurHash2_0.polymurExtrared611(PolymurHash2_0.polymurExtrared611(PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(ka, kb), ka * kb)));
            long k3Tmp = PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(kTmp, k2Tmp = PolymurHash2_0.polymurExtrared611(PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(kTmp, kTmp), kTmp * kTmp))), kTmp * k2Tmp);
            k7Tmp = PolymurHash2_0.polymurExtrared611(PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(k3Tmp, k4Tmp = PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(k2Tmp, k2Tmp), k2Tmp * k2Tmp)), k3Tmp * k4Tmp));
            if (k7Tmp < 0xF00000000000000L) break;
        }
        this.k = kTmp;
        this.k7 = k7Tmp;
        this.k2 = k2Tmp;
        this.s = sSeed ^ 0x6A09E667F3BCC908L;
        this.tweak = tweak;
        this.k3 = PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(kTmp, k2Tmp), kTmp * k2Tmp);
        this.k3x = PolymurHash2_0.polymurExtrared611(this.k3);
        this.k4 = PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(k2Tmp, k2Tmp), k2Tmp * k2Tmp);
        this.k4x = PolymurHash2_0.polymurExtrared611(this.k4);
        this.k5 = PolymurHash2_0.polymurExtrared611(PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(kTmp, this.k4), kTmp * this.k4));
        this.k6 = PolymurHash2_0.polymurExtrared611(PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(k2Tmp, this.k4), k2Tmp * this.k4));
        this.k14 = PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(k7Tmp, k7Tmp), k7Tmp * k7Tmp);
    }

    public static Hasher64 create(long tweak, long seed) {
        return PolymurHash2_0.create(tweak, PolymurHash2_0.polymurMix(seed + 4354685564936845355L), PolymurHash2_0.polymurMix(seed + -6534734903238641935L));
    }

    private long polymurLoadLeU64_0_8(byte[] input, int off, int len) {
        if (len < 4) {
            if (len == 0) {
                return 0L;
            }
            long v = (long)input[off] & 0xFFL;
            v |= ((long)input[off + (len >>> 1)] & 0xFFL) << (len >>> 1 << 3);
            return v |= ((long)input[off + len - 1] & 0xFFL) << (len - 1 << 3);
        }
        long lo = (long)ByteArrayUtil.getInt(input, off) & 0xFFFFFFFFL;
        long hi = (long)ByteArrayUtil.getInt(input, off + len - 4) & 0xFFFFFFFFL;
        return lo | hi << (len - 4 << 3);
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int len) {
        long t1Lo;
        long t1Hi;
        long m0;
        long polyAcc = this.tweak;
        long k3Local = this.k3;
        long k4Local = this.k4;
        if (len > 49) {
            k3Local = this.k3x;
            k4Local = this.k4x;
            long h = 0L;
            do {
                h = this.processBuffer(input, off, h);
                off += 49;
            } while ((len -= 49) > 49);
            long ph = PolymurHash2_0.polymurExtrared611(h);
            long hk14 = PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(ph, this.k14), ph * this.k14);
            polyAcc += PolymurHash2_0.polymurExtrared611(hk14);
        }
        if (len >= 8) {
            m0 = PolymurHash2_0.getLong7(input, off) + this.k2;
            long m1 = PolymurHash2_0.getLong7(input, off + (len - 7 >>> 1)) + this.k7;
            long m2 = (ByteArrayUtil.getLong(input, off + len - 8) >>> 8) + this.k;
            long t0Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m0, m1);
            long t0Lo = m0 * m1;
            t1Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m2, k3Local += (long)len);
            t1Lo = m2 * k3Local;
            if (len <= 21) {
                t1Hi += t0Hi + (long)((t1Lo += t0Lo) + Long.MIN_VALUE < t0Lo + Long.MIN_VALUE ? 1 : 0);
            } else {
                long t0r = PolymurHash2_0.polymurRed611(t0Hi, t0Lo);
                long m3 = PolymurHash2_0.getLong7(input, off + 7) + this.k2;
                long m4 = PolymurHash2_0.getLong7(input, off + 14) + this.k7;
                long m5 = PolymurHash2_0.getLong7(input, off + len - 21) + t0r;
                long m6 = PolymurHash2_0.getLong7(input, off + len - 14) + k4Local;
                long t2Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m3, m4);
                long t2Lo = m3 * m4;
                long t3Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m5, m6);
                long t3Lo = m5 * m6;
                t1Hi += t2Hi + (long)((t1Lo += (t2Lo += Long.MIN_VALUE)) < t2Lo ? 1 : 0);
                t1Hi += t3Hi + (long)((t1Lo += (t3Lo += Long.MIN_VALUE)) + Long.MIN_VALUE < t3Lo ? 1 : 0);
            }
        } else {
            m0 = this.polymurLoadLeU64_0_8(input, off, len) + this.k;
            long lenk2 = (long)len + this.k2;
            t1Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m0, lenk2);
            t1Lo = m0 * lenk2;
        }
        return PolymurHash2_0.polymurMix(polyAcc + PolymurHash2_0.polymurRed611(t1Hi, t1Lo)) + this.s;
    }

    @Override
    public long hashCharsToLong(CharSequence input) {
        long t1Lo;
        long t1Hi;
        long m0;
        long polyAcc = this.tweak;
        long k3Local = this.k3;
        long k4Local = this.k4;
        long len = (long)input.length() << 1;
        long off = 0L;
        if (len > 49L) {
            k3Local = this.k3x;
            k4Local = this.k4x;
            long h = 0L;
            do {
                h = this.processBuffer(input, off, h);
                off += 49L;
            } while ((len -= 49L) > 49L);
            long ph = PolymurHash2_0.polymurExtrared611(h);
            long hk14 = PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(ph, this.k14), ph * this.k14);
            polyAcc += PolymurHash2_0.polymurExtrared611(hk14);
        }
        if (len >= 8L) {
            m0 = PolymurHash2_0.getLong7(input, off) + this.k2;
            long m1 = PolymurHash2_0.getLong7(input, off + (len - 7L >>> 1)) + this.k7;
            long m2 = PolymurHash2_0.getLong7(input, off + len - 7L) + this.k;
            long t0Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m0, m1);
            long t0Lo = m0 * m1;
            t1Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m2, k3Local += len);
            t1Lo = m2 * k3Local;
            if (len <= 21L) {
                t1Hi += t0Hi + (long)((t1Lo += t0Lo) + Long.MIN_VALUE < t0Lo + Long.MIN_VALUE ? 1 : 0);
            } else {
                long t0r = PolymurHash2_0.polymurRed611(t0Hi, t0Lo);
                long m3 = PolymurHash2_0.getLong7(input, off + 7L) + this.k2;
                long m4 = PolymurHash2_0.getLong7(input, off + 14L) + this.k7;
                long m5 = PolymurHash2_0.getLong7(input, off + len - 21L) + t0r;
                long m6 = PolymurHash2_0.getLong7(input, off + len - 14L) + k4Local;
                long t2Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m3, m4);
                long t2Lo = m3 * m4;
                long t3Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m5, m6);
                long t3Lo = m5 * m6;
                t1Hi += t2Hi + (long)((t1Lo += (t2Lo += Long.MIN_VALUE)) < t2Lo ? 1 : 0);
                t1Hi += t3Hi + (long)((t1Lo += (t3Lo += Long.MIN_VALUE)) + Long.MIN_VALUE < t3Lo ? 1 : 0);
            }
        } else {
            m0 = this.polymurLoadLeU64_0_8(input, off, len) + this.k;
            long lenk2 = len + this.k2;
            t1Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m0, lenk2);
            t1Lo = m0 * lenk2;
        }
        return PolymurHash2_0.polymurMix(polyAcc + PolymurHash2_0.polymurRed611(t1Hi, t1Lo)) + this.s;
    }

    private long polymurLoadLeU64_0_8(CharSequence input, long off, long len) {
        int o = (int)((off + len >>> 1) - 1L);
        long r = 0L;
        if (o >= 0) {
            r |= (long)input.charAt(o) << 48;
            if (o - 1 >= 0) {
                r |= (long)input.charAt(o - 1) << 32;
                if (o - 2 >= 0) {
                    r |= (long)input.charAt(o - 2) << 16;
                    if (o - 3 >= 0) {
                        r |= (long)input.charAt(o - 3);
                    }
                }
            }
        }
        return r >>> (int)(-(len << 3));
    }

    private static long getLong7(CharSequence input, long off) {
        return ByteArrayUtil.getLong(input, (int)(off >>> 1)) << (int)(((off ^ 0xFFFFFFFFFFFFFFFFL) & 1L) << 3) >>> 8;
    }

    private long processBuffer(CharSequence input, long off, long h) {
        long v6;
        long v5;
        long v4;
        long v3;
        long v2;
        long v1;
        long v0;
        int o = (int)(off >>> 1);
        long c0 = input.charAt(o);
        long c1 = input.charAt(o + 1);
        long c2 = input.charAt(o + 2);
        long c3 = input.charAt(o + 3);
        long c4 = input.charAt(o + 4);
        long c5 = input.charAt(o + 5);
        long c6 = input.charAt(o + 6);
        long c7 = input.charAt(o + 7);
        long c8 = input.charAt(o + 8);
        long c9 = input.charAt(o + 9);
        long c10 = input.charAt(o + 10);
        long c11 = input.charAt(o + 11);
        long c12 = input.charAt(o + 12);
        long c13 = input.charAt(o + 13);
        long c14 = input.charAt(o + 14);
        long c15 = input.charAt(o + 15);
        long c16 = input.charAt(o + 16);
        long c17 = input.charAt(o + 17);
        long c18 = input.charAt(o + 18);
        long c19 = input.charAt(o + 19);
        long c20 = input.charAt(o + 20);
        long c21 = input.charAt(o + 21);
        long c22 = input.charAt(o + 22);
        long c23 = input.charAt(o + 23);
        long c24 = input.charAt(o + 24);
        if ((off & 1L) == 0L) {
            v0 = c0 << 8 | c1 << 24 | c2 << 40 | c3 << 56;
            v1 = c3 | c4 << 16 | c5 << 32 | c6 << 48;
            v2 = c7 << 8 | c8 << 24 | c9 << 40 | c10 << 56;
            v3 = c10 | c11 << 16 | c12 << 32 | c13 << 48;
            v4 = c14 << 8 | c15 << 24 | c16 << 40 | c17 << 56;
            v5 = c17 | c18 << 16 | c19 << 32 | c20 << 48;
            v6 = c21 << 8 | c22 << 24 | c23 << 40 | c24 << 56;
        } else {
            v0 = c0 | c1 << 16 | c2 << 32 | c3 << 48;
            v1 = c4 << 8 | c5 << 24 | c6 << 40 | c7 << 56;
            v2 = c7 | c8 << 16 | c9 << 32 | c10 << 48;
            v3 = c11 << 8 | c12 << 24 | c13 << 40 | c14 << 56;
            v4 = c14 | c15 << 16 | c16 << 32 | c17 << 48;
            v5 = c18 << 8 | c19 << 24 | c20 << 40 | c21 << 56;
            v6 = c21 | c22 << 16 | c23 << 32 | c24 << 48;
        }
        return this.processBuffer(v0 >>> 8, v1 >>> 8, v2 >>> 8, v3 >>> 8, v4 >>> 8, v5 >>> 8, v6 >>> 8, h);
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    private long processBuffer(byte[] b, int off, long h) {
        return this.processBuffer(PolymurHash2_0.getLong7(b, off), PolymurHash2_0.getLong7(b, off + 7), PolymurHash2_0.getLong7(b, off + 14), PolymurHash2_0.getLong7(b, off + 21), PolymurHash2_0.getLong7(b, off + 28), PolymurHash2_0.getLong7(b, off + 35), PolymurHash2_0.getLong7(b, off + 42), h);
    }

    private static long getLong7(byte[] b, int off) {
        return ByteArrayUtil.getLong(b, off) & 0xFFFFFFFFFFFFFFL;
    }

    private long processBuffer(long v0, long v1, long v2, long v3, long v4, long v5, long v6, long h) {
        long m0 = v0 + this.k;
        long m1 = v1 + this.k6;
        long m2 = v2 + this.k2;
        long m3 = v3 + this.k5;
        long m4 = v4 + this.k3x;
        long m5 = v5 + this.k4x;
        long m6 = v6 + h;
        long t0Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m0, m1);
        long t0Lo = m0 * m1;
        long t1Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m2, m3);
        long t1Lo = m2 * m3 + Long.MIN_VALUE;
        long t2Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m4, m5);
        long t2Lo = m4 * m5;
        long t3Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m6, this.k7);
        long t3Lo = m6 * this.k7 + Long.MIN_VALUE;
        t0Hi += t1Hi + (long)((t0Lo += t1Lo) < t1Lo ? 1 : 0);
        return PolymurHash2_0.polymurRed611(t0Hi += (t2Hi += t3Hi + (long)((t2Lo += t3Lo) < t3Lo ? 1 : 0)) + (long)((t0Lo += t2Lo) + Long.MIN_VALUE < t2Lo ? 1 : 0), t0Lo);
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        long m0 = (v1 & 0xFFFFFFFFFFFFFFL) + this.k2;
        long m1 = ((v1 >>> 32 | v2 << 32) & 0xFFFFFFFFFFFFFFL) + this.k7;
        long m2 = (v2 >>> 8) + this.k;
        long t0Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m0, m1);
        long t0Lo = m0 * m1;
        long k31 = this.k3 + 16L;
        long t1Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m2, k31);
        long t1Lo = m2 * k31 + t0Lo;
        return PolymurHash2_0.polymurMix(this.tweak + PolymurHash2_0.polymurRed611(t1Hi += t0Hi + (long)(t1Lo + Long.MIN_VALUE < t0Lo + Long.MIN_VALUE ? 1 : 0), t1Lo)) + this.s;
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        long k31 = this.k3 + 24L;
        long m0 = (v1 & 0xFFFFFFFFFFFFFFL) + this.k2;
        long m1 = (v2 & 0xFFFFFFFFFFFFFFL) + this.k7;
        long m2 = (v3 >>> 8) + this.k;
        long t0Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m0, m1);
        long t0Lo = m0 * m1;
        long t1Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m2, k31);
        long t1Lo = m2 * k31;
        long t0r = PolymurHash2_0.polymurRed611(t0Hi, t0Lo);
        long m3 = ((v1 >>> 56 | v2 << 8) & 0xFFFFFFFFFFFFFFL) + this.k2;
        long m4 = ((v2 >>> 48 | v3 << 16) & 0xFFFFFFFFFFFFFFL) + this.k7;
        long m5 = ((v1 >>> 24 | v2 << 40) & 0xFFFFFFFFFFFFFFL) + t0r;
        long m6 = ((v2 >>> 16 | v3 << 48) & 0xFFFFFFFFFFFFFFL) + this.k4;
        long t2Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m3, m4);
        long t2Lo = m3 * m4;
        long t3Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m5, m6);
        long t3Lo = m5 * m6;
        t1Hi += t2Hi + (long)((t1Lo += (t2Lo += Long.MIN_VALUE)) < t2Lo ? 1 : 0);
        return PolymurHash2_0.polymurMix(this.tweak + PolymurHash2_0.polymurRed611(t1Hi += t3Hi + (long)((t1Lo += (t3Lo += Long.MIN_VALUE)) + Long.MIN_VALUE < t3Lo ? 1 : 0), t1Lo)) + this.s;
    }

    private long finish12Bytes(long m0, long m1, long m2) {
        long k3Local = this.k3 + 12L;
        long t0Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m0 += this.k2, m1 += this.k7);
        long t0Lo = m0 * m1;
        long t1Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m2 += this.k, k3Local);
        long t1Lo = m2 * k3Local;
        return PolymurHash2_0.polymurMix(this.tweak + PolymurHash2_0.polymurRed611(t1Hi += t0Hi + (long)((t1Lo += t0Lo) + Long.MIN_VALUE < t0Lo + Long.MIN_VALUE ? 1 : 0), t1Lo)) + this.s;
    }

    @Override
    public long hashLongIntToLong(long v1, int v2) {
        long m0 = v1 & 0xFFFFFFFFFFFFFFL;
        long m1 = (v1 >>> 16) + (((long)v2 & 0xFFL) << 48);
        long m2 = (v1 >>> 40) + (((long)v2 & 0xFFFFFFFFL) << 24);
        return this.finish12Bytes(m0, m1, m2);
    }

    @Override
    public long hashIntIntIntToLong(int v1, int v2, int v3) {
        long v1l = (long)v1 & 0xFFFFFFFFL;
        long v2l = (long)v2 & 0xFFFFFFFFL;
        long m0 = v1l + (((long)v2 & 0xFFFFFFL) << 32);
        long m1 = (v1l >>> 16) + (v2l << 16) + (((long)v3 & 0xFFL) << 48);
        long m2 = (v2l >>> 8) + (((long)v3 & 0xFFFFFFFFL) << 24);
        return this.finish12Bytes(m0, m1, m2);
    }

    @Override
    public long hashIntLongToLong(int v1, long v2) {
        long v1l = (long)v1 & 0xFFFFFFFFL;
        long m0 = v1l + ((v2 & 0xFFFFFFL) << 32);
        long m1 = (v1l >>> 16) + ((v2 & 0xFFFFFFFFFFL) << 16);
        long m2 = v2 >>> 8;
        return this.finish12Bytes(m0, m1, m2);
    }

    private class HashStreamImpl
    implements AbstractHashStream64 {
        private final byte[] buffer = new byte[57];
        private long byteCount = 0L;
        private int offset = 0;
        private long h = 0L;

        private HashStreamImpl() {
        }

        @Override
        public HashStream64 reset() {
            this.byteCount = 0L;
            this.offset = 0;
            this.h = 0L;
            return this;
        }

        @Override
        public HashStream64 copy() {
            HashStreamImpl hashStream = new HashStreamImpl();
            hashStream.byteCount = this.byteCount;
            hashStream.offset = this.offset;
            hashStream.h = this.h;
            System.arraycopy(this.buffer, 0, hashStream.buffer, 0, this.buffer.length);
            return hashStream;
        }

        @Override
        public HashStream64 putByte(byte v) {
            this.buffer[this.offset] = v;
            ++this.offset;
            ++this.byteCount;
            if (this.offset > 49) {
                this.offset -= 49;
                this.processBuffer();
                this.buffer[0] = this.buffer[49];
            }
            return this;
        }

        @Override
        public HashStream64 putShort(short v) {
            ByteArrayUtil.setShort(this.buffer, this.offset, v);
            this.offset += 2;
            this.byteCount += 2L;
            if (this.offset > 49) {
                this.offset -= 49;
                this.processBuffer();
                ByteArrayUtil.setShort(this.buffer, 0, ByteArrayUtil.getShort(this.buffer, 49));
            }
            return this;
        }

        @Override
        public HashStream64 putChar(char v) {
            ByteArrayUtil.setChar(this.buffer, this.offset, v);
            this.offset += 2;
            this.byteCount += 2L;
            if (this.offset > 49) {
                this.offset -= 49;
                this.processBuffer();
                ByteArrayUtil.setChar(this.buffer, 0, ByteArrayUtil.getChar(this.buffer, 49));
            }
            return this;
        }

        @Override
        public HashStream64 putInt(int v) {
            ByteArrayUtil.setInt(this.buffer, this.offset, v);
            this.offset += 4;
            this.byteCount += 4L;
            if (this.offset > 49) {
                this.offset -= 49;
                this.processBuffer();
                ByteArrayUtil.setInt(this.buffer, 0, ByteArrayUtil.getInt(this.buffer, 49));
            }
            return this;
        }

        @Override
        public HashStream64 putLong(long v) {
            ByteArrayUtil.setLong(this.buffer, this.offset, v);
            this.offset += 8;
            this.byteCount += 8L;
            if (this.offset > 49) {
                this.offset -= 49;
                this.processBuffer();
                ByteArrayUtil.setLong(this.buffer, 0, ByteArrayUtil.getLong(this.buffer, 49));
            }
            return this;
        }

        @Override
        public HashStream64 putBytes(byte[] b, int off, int len) {
            this.byteCount += (long)len;
            int x = 49 - this.offset;
            if (len > x) {
                if (this.offset != 0) {
                    System.arraycopy(b, off, this.buffer, this.offset, x);
                    this.processBuffer();
                    len -= x;
                    off += x;
                    this.offset = 0;
                }
                while (len > 49) {
                    this.h = PolymurHash2_0.this.processBuffer(b, off, this.h);
                    len -= 49;
                    off += 49;
                }
            }
            System.arraycopy(b, off, this.buffer, this.offset, len);
            this.offset += len;
            return this;
        }

        @Override
        public HashStream64 putChars(CharSequence s) {
            int i = 0;
            this.byteCount += (long)s.length() << 1;
            if (s.length() >= 51 - this.offset >>> 1) {
                i = 51 - this.offset >>> 1;
                ByteArrayUtil.copyCharsToByteArray(s, 0, this.buffer, this.offset, i);
                this.offset += i << 1;
                this.offset -= 49;
                this.processBuffer();
                ByteArrayUtil.setChar(this.buffer, 0, ByteArrayUtil.getChar(this.buffer, 49));
                if (i <= s.length() - (51 - this.offset >>> 1)) {
                    long x = ByteArrayUtil.getChar(this.buffer, 0);
                    do {
                        long v6;
                        long v5;
                        long v4;
                        long v3;
                        long v2;
                        long v1;
                        long v0;
                        long c0;
                        long c1 = s.charAt(i + 0);
                        long c2 = s.charAt(i + 1);
                        long c3 = s.charAt(i + 2);
                        long c4 = s.charAt(i + 3);
                        long c5 = s.charAt(i + 4);
                        long c6 = s.charAt(i + 5);
                        long c7 = s.charAt(i + 6);
                        long c8 = s.charAt(i + 7);
                        long c9 = s.charAt(i + 8);
                        long c10 = s.charAt(i + 9);
                        long c11 = s.charAt(i + 10);
                        long c12 = s.charAt(i + 11);
                        long c13 = s.charAt(i + 12);
                        long c14 = s.charAt(i + 13);
                        long c15 = s.charAt(i + 14);
                        long c16 = s.charAt(i + 15);
                        long c17 = s.charAt(i + 16);
                        long c18 = s.charAt(i + 17);
                        long c19 = s.charAt(i + 18);
                        long c20 = s.charAt(i + 19);
                        long c21 = s.charAt(i + 20);
                        long c22 = s.charAt(i + 21);
                        long c23 = s.charAt(i + 22);
                        long c24 = s.charAt(i + 23);
                        if (this.offset == 1) {
                            c0 = (x & 0xFFL) << 8;
                            v0 = c0 | c1 << 16 | c2 << 32 | c3 << 48;
                            v1 = c4 << 8 | c5 << 24 | c6 << 40 | c7 << 56;
                            v2 = c7 | c8 << 16 | c9 << 32 | c10 << 48;
                            v3 = c11 << 8 | c12 << 24 | c13 << 40 | c14 << 56;
                            v4 = c14 | c15 << 16 | c16 << 32 | c17 << 48;
                            v5 = c18 << 8 | c19 << 24 | c20 << 40 | c21 << 56;
                            v6 = c21 | c22 << 16 | c23 << 32 | c24 << 48;
                            this.offset = 2;
                            x = s.charAt(i + 24);
                            i += 25;
                        } else {
                            c0 = x;
                            v0 = c0 << 8 | c1 << 24 | c2 << 40 | c3 << 56;
                            v1 = c3 | c4 << 16 | c5 << 32 | c6 << 48;
                            v2 = c7 << 8 | c8 << 24 | c9 << 40 | c10 << 56;
                            v3 = c10 | c11 << 16 | c12 << 32 | c13 << 48;
                            v4 = c14 << 8 | c15 << 24 | c16 << 40 | c17 << 56;
                            v5 = c17 | c18 << 16 | c19 << 32 | c20 << 48;
                            v6 = c21 << 8 | c22 << 24 | c23 << 40 | c24 << 56;
                            this.offset = 1;
                            x = c24 >>> 8;
                            i += 24;
                        }
                        this.h = PolymurHash2_0.this.processBuffer(v0 >>> 8, v1 >>> 8, v2 >>> 8, v3 >>> 8, v4 >>> 8, v5 >>> 8, v6 >>> 8, this.h);
                    } while (i <= s.length() - (51 - this.offset >>> 1));
                    ByteArrayUtil.setChar(this.buffer, 0, (char)x);
                }
            }
            ByteArrayUtil.copyCharsToByteArray(s, i, this.buffer, this.offset, s.length() - i);
            this.offset += s.length() - i << 1;
            return this;
        }

        private void processBuffer() {
            this.h = PolymurHash2_0.this.processBuffer(this.buffer, 0, this.h);
        }

        private long finish() {
            long polyAcc = PolymurHash2_0.this.tweak;
            if (this.byteCount >= 8L) {
                long k3Local = PolymurHash2_0.this.k3;
                long k4Local = PolymurHash2_0.this.k4;
                if (this.byteCount > 49L) {
                    k3Local = PolymurHash2_0.this.k3x;
                    k4Local = PolymurHash2_0.this.k4x;
                    long ph = PolymurHash2_0.polymurExtrared611(this.h);
                    long hk14 = PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(ph, PolymurHash2_0.this.k14), ph * PolymurHash2_0.this.k14);
                    polyAcc += PolymurHash2_0.polymurExtrared611(hk14);
                }
                if (this.offset >= 8) {
                    long m0 = PolymurHash2_0.getLong7(this.buffer, 0) + PolymurHash2_0.this.k2;
                    long m1 = PolymurHash2_0.getLong7(this.buffer, this.offset - 7 >>> 1) + PolymurHash2_0.this.k7;
                    long m2 = (ByteArrayUtil.getLong(this.buffer, this.offset - 8) >>> 8) + PolymurHash2_0.this.k;
                    long t0Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m0, m1);
                    long t0Lo = m0 * m1;
                    long t1Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m2, k3Local += (long)this.offset);
                    long t1Lo = m2 * k3Local;
                    if (this.offset <= 21) {
                        t1Hi += t0Hi + (long)((t1Lo += t0Lo) + Long.MIN_VALUE < t0Lo + Long.MIN_VALUE ? 1 : 0);
                    } else {
                        long t0r = PolymurHash2_0.polymurRed611(t0Hi, t0Lo);
                        long m3 = PolymurHash2_0.getLong7(this.buffer, 7) + PolymurHash2_0.this.k2;
                        long m4 = PolymurHash2_0.getLong7(this.buffer, 14) + PolymurHash2_0.this.k7;
                        long m5 = PolymurHash2_0.getLong7(this.buffer, this.offset - 21) + t0r;
                        long m6 = PolymurHash2_0.getLong7(this.buffer, this.offset - 14) + k4Local;
                        long t2Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m3, m4);
                        long t2Lo = m3 * m4;
                        long t3Hi = UnsignedMultiplyUtil.unsignedMultiplyHigh(m5, m6);
                        long t3Lo = m5 * m6;
                        t1Hi += t2Hi + (long)((t1Lo += (t2Lo += Long.MIN_VALUE)) < t2Lo ? 1 : 0);
                        t1Hi += t3Hi + (long)((t1Lo += (t3Lo += Long.MIN_VALUE)) + Long.MIN_VALUE < t3Lo ? 1 : 0);
                    }
                    return polyAcc + PolymurHash2_0.polymurRed611(t1Hi, t1Lo);
                }
            }
            long m0 = PolymurHash2_0.this.k;
            if (this.offset > 0) {
                m0 += ByteArrayUtil.getLong(this.buffer, 0) & -1L >>> -(this.offset << 3);
            }
            long lenk2 = (long)this.offset + PolymurHash2_0.this.k2;
            return polyAcc + PolymurHash2_0.polymurRed611(UnsignedMultiplyUtil.unsignedMultiplyHigh(m0, lenk2), m0 * lenk2);
        }

        @Override
        public long getAsLong() {
            return PolymurHash2_0.polymurMix(this.finish()) + PolymurHash2_0.this.s;
        }
    }
}

