/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2;

import io.github.dmlloyd.classfile.Annotation;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.creator.AnnotatableCreator;
import io.quarkus.gizmo2.creator.AnnotationCreator;
import io.quarkus.gizmo2.impl.TypeAnnotatableCreatorImpl;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TypeArgument {
    TypeArgument() {
    }

    public static OfExact of(Class<?> type) {
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Primitive types cannot be type arguments");
        }
        return TypeArgument.ofExact((GenericType.OfReference)GenericType.of(type));
    }

    public static OfExact of(ClassDesc type) {
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Primitive types cannot be type arguments");
        }
        return TypeArgument.ofExact((GenericType.OfReference)GenericType.of(type));
    }

    public static OfExact ofExact(GenericType.OfReference type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        OfExact ofExact = type.exactArg;
        if (ofExact == null) {
            ofExact = type.exactArg = new OfExact(type);
        }
        return ofExact;
    }

    public static OfExtends ofExtends(GenericType.OfReference bound) {
        Assert.checkNotNullParam((String)"bound", (Object)bound);
        OfExtends ofExtends = bound.extendsArg;
        if (ofExtends == null) {
            ofExtends = bound.extendsArg = new OfExtends(List.of(), List.of(), bound);
        }
        return ofExtends;
    }

    public static OfSuper ofSuper(GenericType.OfReference bound) {
        Assert.checkNotNullParam((String)"bound", (Object)bound);
        OfSuper ofSuper = bound.superArg;
        if (ofSuper == null) {
            ofSuper = bound.superArg = new OfSuper(List.of(), List.of(), bound);
        }
        return ofSuper;
    }

    public static OfUnbounded ofUnbounded() {
        return OfUnbounded.instance;
    }

    public abstract boolean hasVisibleAnnotations();

    public abstract boolean hasInvisibleAnnotations();

    public final boolean hasAnnotations() {
        return this.hasVisibleAnnotations() || this.hasInvisibleAnnotations();
    }

    public abstract StringBuilder toString(StringBuilder var1);

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public static final class OfExact
    extends TypeArgument
    implements OfTyped {
        private final GenericType.OfReference type;

        OfExact(GenericType.OfReference type) {
            this.type = type;
        }

        @Override
        public GenericType.OfReference type() {
            return this.type;
        }

        @Override
        public boolean hasVisibleAnnotations() {
            return this.type.hasVisibleAnnotations();
        }

        @Override
        public boolean hasInvisibleAnnotations() {
            return this.type.hasInvisibleAnnotations();
        }

        public boolean equals(Object other) {
            OfExact oe;
            return other instanceof OfExact && this.equals(oe = (OfExact)other);
        }

        public boolean equals(OfExact other) {
            return this == other || this.type.equals(other.type);
        }

        public int hashCode() {
            return Objects.hashCode(this.type);
        }

        @Override
        public StringBuilder toString(StringBuilder b) {
            return this.type.toString(b);
        }
    }

    public static final class OfExtends
    extends OfWildcard
    implements OfBounded {
        private final GenericType.OfReference bound;

        OfExtends(List<Annotation> visible, List<Annotation> invisible, GenericType.OfReference bound) {
            super(visible, invisible);
            this.bound = bound;
        }

        @Override
        public GenericType.OfReference bound() {
            return this.bound;
        }

        @Override
        public boolean hasVisibleAnnotations() {
            return super.hasVisibleAnnotations() || this.bound.hasVisibleAnnotations();
        }

        @Override
        public boolean hasInvisibleAnnotations() {
            return super.hasInvisibleAnnotations() || this.bound.hasInvisibleAnnotations();
        }

        @Override
        OfExtends copy(List<Annotation> visible, List<Annotation> invisible) {
            return new OfExtends(visible, invisible, this.bound());
        }

        @Override
        public OfExtends withAnnotations(Consumer<AnnotatableCreator> builder) {
            return (OfExtends)super.withAnnotations(builder);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfExtends withAnnotation(Class<A> annotationType) {
            return (OfExtends)super.withAnnotation(annotationType);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfExtends withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
            return (OfExtends)super.withAnnotation(annotationType, builder);
        }

        @Override
        public boolean equals(OfWildcard other) {
            OfExtends oe;
            return other instanceof OfExtends && this.equals(oe = (OfExtends)other);
        }

        public boolean equals(OfExtends other) {
            return this == other || super.equals(other) && this.bound.equals(other.bound);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 19 + this.bound.hashCode();
        }

        @Override
        public StringBuilder toString(StringBuilder b) {
            return this.bound.toString(super.toString(b).append("? extends "));
        }
    }

    public static final class OfSuper
    extends OfWildcard
    implements OfBounded {
        private final GenericType.OfReference bound;

        OfSuper(List<Annotation> visible, List<Annotation> invisible, GenericType.OfReference bound) {
            super(visible, invisible);
            this.bound = bound;
        }

        @Override
        public GenericType.OfReference bound() {
            return this.bound;
        }

        @Override
        public boolean hasVisibleAnnotations() {
            return super.hasVisibleAnnotations() || this.bound.hasVisibleAnnotations();
        }

        @Override
        public boolean hasInvisibleAnnotations() {
            return super.hasInvisibleAnnotations() || this.bound.hasInvisibleAnnotations();
        }

        @Override
        OfSuper copy(List<Annotation> visible, List<Annotation> invisible) {
            return new OfSuper(visible, invisible, this.bound());
        }

        @Override
        public OfSuper withAnnotations(Consumer<AnnotatableCreator> builder) {
            return (OfSuper)super.withAnnotations(builder);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfSuper withAnnotation(Class<A> annotationType) {
            return (OfSuper)super.withAnnotation(annotationType);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfSuper withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
            return (OfSuper)super.withAnnotation(annotationType, builder);
        }

        @Override
        public boolean equals(OfWildcard other) {
            OfSuper os;
            return other instanceof OfSuper && this.equals(os = (OfSuper)other);
        }

        public boolean equals(OfSuper other) {
            return this == other || super.equals(other) && this.bound.equals(other.bound);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 19 + this.bound.hashCode();
        }

        @Override
        public StringBuilder toString(StringBuilder b) {
            return this.bound.toString(super.toString(b).append("? super "));
        }
    }

    public static final class OfUnbounded
    extends OfWildcard {
        private static final OfUnbounded instance = new OfUnbounded();

        private OfUnbounded() {
            super(List.of(), List.of());
        }

        private OfUnbounded(List<Annotation> visible, List<Annotation> invisible) {
            super(visible, invisible);
        }

        @Override
        OfUnbounded copy(List<Annotation> visible, List<Annotation> invisible) {
            return new OfUnbounded(visible, invisible);
        }

        @Override
        public OfUnbounded withAnnotations(Consumer<AnnotatableCreator> builder) {
            return (OfUnbounded)super.withAnnotations(builder);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfUnbounded withAnnotation(Class<A> annotationType) {
            return (OfUnbounded)super.withAnnotation(annotationType);
        }

        @Override
        public <A extends java.lang.annotation.Annotation> OfUnbounded withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
            return (OfUnbounded)super.withAnnotation(annotationType, builder);
        }

        @Override
        public boolean equals(OfWildcard other) {
            OfUnbounded ou;
            return other instanceof OfUnbounded && this.equals(ou = (OfUnbounded)other);
        }

        public boolean equals(OfUnbounded other) {
            return this == other || super.equals(other);
        }

        @Override
        public StringBuilder toString(StringBuilder b) {
            return super.toString(b).append('?');
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfBounded
    extends OfTyped {
        @Override
        default public GenericType.OfReference type() {
            return this.bound();
        }

        public GenericType.OfReference bound();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class OfWildcard
    extends TypeArgument {
        final List<Annotation> visible;
        final List<Annotation> invisible;

        OfWildcard(List<Annotation> visible, List<Annotation> invisible) {
            this.visible = visible;
            this.invisible = invisible;
        }

        List<Annotation> visible() {
            return this.visible;
        }

        List<Annotation> invisible() {
            return this.invisible;
        }

        abstract OfWildcard copy(List<Annotation> var1, List<Annotation> var2);

        @Override
        public boolean hasVisibleAnnotations() {
            return !this.visible.isEmpty();
        }

        @Override
        public boolean hasInvisibleAnnotations() {
            return !this.invisible.isEmpty();
        }

        public OfWildcard withAnnotations(Consumer<AnnotatableCreator> builder) {
            TypeAnnotatableCreatorImpl tac = new TypeAnnotatableCreatorImpl(this.visible, this.invisible);
            builder.accept(tac);
            return this.copy(tac.visible(), tac.invisible());
        }

        public <A extends java.lang.annotation.Annotation> OfWildcard withAnnotation(Class<A> annotationType) {
            return this.withAnnotations(ac -> ac.addAnnotation(annotationType));
        }

        public <A extends java.lang.annotation.Annotation> OfWildcard withAnnotation(Class<A> annotationType, Consumer<AnnotationCreator<A>> builder) {
            return this.withAnnotations(ac -> ac.addAnnotation(annotationType, builder));
        }

        public boolean equals(Object other) {
            OfWildcard ow;
            return other instanceof OfWildcard && this.equals(ow = (OfWildcard)other);
        }

        public boolean equals(OfWildcard other) {
            return this == other || this.visible.equals(other.visible) && this.invisible.equals(other.invisible);
        }

        public int hashCode() {
            return Objects.hash(this.visible, this.invisible);
        }

        @Override
        public StringBuilder toString(StringBuilder b) {
            for (Annotation annotation : this.visible) {
                Util.appendAnnotation(b, annotation).append(' ');
            }
            for (Annotation annotation : this.invisible) {
                Util.appendAnnotation(b, annotation).append(' ');
            }
            return b;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface OfTyped {
        public GenericType.OfReference type();
    }
}

