/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.smallrye.common.constraint.Assert;
import java.lang.constant.ClassDesc;
import java.util.function.BiFunction;

final class Neg
extends Item {
    private final Item a;

    Neg(Expr a) {
        a = Conversions.convert(a, Conversions.unboxingConversion(a.type()).orElse(a.type()));
        this.a = (Item)a;
        TypeKind typeKind = a.typeKind();
        if (typeKind == TypeKind.REFERENCE || typeKind == TypeKind.BOOLEAN || typeKind == TypeKind.VOID) {
            throw new IllegalArgumentException("Cannot negate non-numeric expression: " + String.valueOf(a));
        }
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.a.process(node.prev(), op);
    }

    @Override
    public ClassDesc type() {
        return this.a.type();
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        switch (this.typeKind().asLoadable()) {
            case INT: {
                cb.ineg();
                break;
            }
            case LONG: {
                cb.lneg();
                break;
            }
            case FLOAT: {
                cb.fneg();
                break;
            }
            case DOUBLE: {
                cb.dneg();
                break;
            }
            default: {
                throw Assert.impossibleSwitchCase((Object)((Object)this.typeKind().asLoadable()));
            }
        }
    }
}

