/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Objects;
import java.util.Set;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheInvalidationEvent;

@ProtoTypeId(value=65594)
public class UserUpdatedEvent
extends InvalidationEvent
implements UserCacheInvalidationEvent {
    @ProtoField(value=2)
    final String username;
    @ProtoField(value=3)
    final String email;
    @ProtoField(value=4)
    final String realmId;

    private UserUpdatedEvent(String id, String username, String email, String realmId) {
        super(id);
        this.username = Objects.requireNonNull(username);
        this.email = email;
        this.realmId = Objects.requireNonNull(realmId);
    }

    public static UserUpdatedEvent create(String id, String username, String email, String realmId) {
        return new UserUpdatedEvent(id, username, email, realmId);
    }

    @ProtoFactory
    static UserUpdatedEvent protoFactory(String id, String username, String email, String realmId) {
        return new UserUpdatedEvent(id, username, email, realmId);
    }

    public String toString() {
        return String.format("UserUpdatedEvent [ userId=%s, username=%s, email=%s ]", this.getId(), this.username, this.email);
    }

    @Override
    public void addInvalidations(UserCacheManager userCache, Set<String> invalidations) {
        userCache.userUpdatedInvalidations(this.getId(), this.username, this.email, this.realmId, invalidations);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserUpdatedEvent that = (UserUpdatedEvent)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.email, that.email) && Objects.equals(this.realmId, that.realmId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.username, this.email, this.realmId);
    }
}

