/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public final class TimeSpanConverter
implements Serializable {
    private static final int ONE_HOUR_IN_SECONDS = 3600;
    private static final int ONE_DAY_IN_SECONDS = 86400;
    private static final int ONE_MONTH_IN_SECONDS = 2592000;
    private static final long serialVersionUID = 8665013607650804076L;
    private final MessageFormat[] formats = new MessageFormat[6];
    private final DateTimeFormatter dateMonth;
    private final DateTimeFormatter dateMonthYear;
    private static final int NOW = 0;
    private static final int N_SECONDS_AGO = 1;
    private static final int A_MINUTE_AGO = 2;
    private static final int N_MINUTES_AGO = 3;
    private static final int AN_HOUR_AGO = 4;
    private static final int N_HOURS_AGO = 5;

    public TimeSpanConverter() {
        this(Locale.getDefault());
    }

    public TimeSpanConverter(Locale locale) {
        String language = locale.getLanguage();
        if ("it".equals(language)) {
            this.formats[0] = new MessageFormat("Ora");
            this.formats[1] = new MessageFormat("{0} secondi fa");
            this.formats[2] = new MessageFormat("1 minuto fa");
            this.formats[3] = new MessageFormat("{0} minuti fa");
            this.formats[4] = new MessageFormat("1 ora fa");
            this.formats[5] = new MessageFormat("{0} ore fa");
            this.dateMonth = DateTimeFormatter.ofPattern("d MMM", locale);
            this.dateMonthYear = DateTimeFormatter.ofPattern("d MMM yy", locale);
        } else if ("kr".equals(language)) {
            this.formats[0] = new MessageFormat("\uc9c0\uae08");
            this.formats[1] = new MessageFormat("{0}\ucd08 \uc804");
            this.formats[2] = new MessageFormat("1\ubd84 \uc804");
            this.formats[3] = new MessageFormat("{0}\ubd84 \uc804");
            this.formats[4] = new MessageFormat("1\uc2dc\uac04 \uc804");
            this.formats[5] = new MessageFormat("{0} ore fa");
            this.dateMonth = DateTimeFormatter.ofPattern("M\uc6d4 d\uc77c", locale);
            this.dateMonthYear = DateTimeFormatter.ofPattern("yy\ub144 M\uc6d4 d\uc77c", locale);
        } else if ("es".equals(language)) {
            this.formats[0] = new MessageFormat("Ahora");
            this.formats[1] = new MessageFormat("hace {0} segundos");
            this.formats[2] = new MessageFormat("hace 1 minuto");
            this.formats[3] = new MessageFormat("hace {0} minutos");
            this.formats[4] = new MessageFormat("hace 1 hora");
            this.formats[5] = new MessageFormat("hace {0} horas");
            this.dateMonth = DateTimeFormatter.ofPattern("d MMM", locale);
            this.dateMonthYear = DateTimeFormatter.ofPattern("d MMM yy", locale);
        } else if ("fr".equals(language)) {
            this.formats[0] = new MessageFormat("Maintenant");
            this.formats[1] = new MessageFormat("Il y a {0} secondes");
            this.formats[2] = new MessageFormat("Il y a 1 minute");
            this.formats[3] = new MessageFormat("Il y a {0} minutes");
            this.formats[4] = new MessageFormat("Il y a 1 heure");
            this.formats[5] = new MessageFormat("Il y a {0} heures");
            this.dateMonth = DateTimeFormatter.ofPattern("d MMM", locale);
            this.dateMonthYear = DateTimeFormatter.ofPattern("d MMM yy", locale);
        } else if ("de".equals(language)) {
            this.formats[0] = new MessageFormat("Jetzt");
            this.formats[1] = new MessageFormat("vor {0} Sekunden");
            this.formats[2] = new MessageFormat("vor 1 Minute");
            this.formats[3] = new MessageFormat("vor {0} Minuten");
            this.formats[4] = new MessageFormat("vor 1 Stunde");
            this.formats[5] = new MessageFormat("vor {0} Stunden");
            this.dateMonth = DateTimeFormatter.ofPattern("d MMM", locale);
            this.dateMonthYear = DateTimeFormatter.ofPattern("d MMM yy", locale);
        } else if ("ja".equals(language)) {
            this.formats[0] = new MessageFormat("\u4eca");
            this.formats[1] = new MessageFormat("{0}\u79d2\u524d");
            this.formats[2] = new MessageFormat("1\u5206\u524d");
            this.formats[3] = new MessageFormat("{0}\u5206\u524d");
            this.formats[4] = new MessageFormat("1\u6642\u9593\u524d");
            this.formats[5] = new MessageFormat("{0}\u6642\u9593\u524d");
            this.dateMonth = DateTimeFormatter.ofPattern("M\u6708d\u65e5", locale);
            this.dateMonthYear = DateTimeFormatter.ofPattern("yy\u5e74M\u6708d\u65e5", locale);
        } else {
            this.formats[0] = new MessageFormat("now");
            this.formats[1] = new MessageFormat("{0} seconds ago");
            this.formats[2] = new MessageFormat("1 minute ago");
            this.formats[3] = new MessageFormat("{0} minutes ago");
            this.formats[4] = new MessageFormat("1 hour ago");
            this.formats[5] = new MessageFormat("{0} hours ago");
            this.dateMonth = DateTimeFormatter.ofPattern("d MMM", Locale.ENGLISH);
            this.dateMonthYear = DateTimeFormatter.ofPattern("d MMM yy", Locale.ENGLISH);
        }
    }

    public String toTimeSpanString(LocalDateTime date) {
        return this.toTimeSpanString(date.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public String toTimeSpanString(long milliseconds) {
        int deltaInSeconds = (int)((System.currentTimeMillis() - milliseconds) / 1000L);
        if (deltaInSeconds >= 86400) {
            if (deltaInSeconds >= 2592000) {
                return this.dateMonthYear.format(Instant.ofEpochMilli(milliseconds).atZone(ZoneId.systemDefault()).toLocalDateTime());
            }
            return this.dateMonth.format(Instant.ofEpochMilli(milliseconds).atZone(ZoneId.systemDefault()).toLocalDateTime());
        }
        return this.toTimeSpanString(deltaInSeconds);
    }

    private String toTimeSpanString(int deltaInSeconds) {
        if (deltaInSeconds <= 1) {
            return this.formats[0].format(null);
        }
        if (deltaInSeconds < 60) {
            return this.formats[1].format(new Object[]{deltaInSeconds});
        }
        if (deltaInSeconds < 2700) {
            int minutes = deltaInSeconds / 60;
            if (minutes == 1) {
                return this.formats[2].format(null);
            }
            return this.formats[3].format(new Object[]{minutes});
        }
        if (deltaInSeconds < 6300) {
            return this.formats[4].format(null);
        }
        int hours = (deltaInSeconds + 900) / 3600;
        return this.formats[5].format(new Object[]{hours});
    }
}

