/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.protocol.oid4vc.model.CredentialRequestEncryptionMetadata;
import org.keycloak.protocol.oid4vc.model.CredentialResponseEncryptionMetadata;
import org.keycloak.protocol.oid4vc.model.DisplayObject;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CredentialIssuer {
    @JsonProperty(value="credential_issuer")
    private String credentialIssuer;
    @JsonProperty(value="credential_endpoint")
    private String credentialEndpoint;
    @JsonProperty(value="nonce_endpoint")
    private String nonceEndpoint;
    @JsonProperty(value="deferred_credential_endpoint")
    private String deferredCredentialEndpoint;
    @JsonProperty(value="authorization_servers")
    private List<String> authorizationServers;
    @JsonProperty(value="batch_credential_issuance")
    private BatchCredentialIssuance batchCredentialIssuance;
    @JsonProperty(value="credential_configurations_supported")
    private Map<String, SupportedCredentialConfiguration> credentialsSupported;
    @JsonProperty(value="display")
    private List<DisplayObject> display;
    @JsonProperty(value="credential_response_encryption")
    private CredentialResponseEncryptionMetadata credentialResponseEncryption;
    @JsonProperty(value="credential_request_encryption")
    private CredentialRequestEncryptionMetadata credentialRequestEncryption;

    public String getCredentialIssuer() {
        return this.credentialIssuer;
    }

    public CredentialIssuer setCredentialIssuer(String credentialIssuer) {
        this.credentialIssuer = credentialIssuer;
        return this;
    }

    public String getCredentialEndpoint() {
        return this.credentialEndpoint;
    }

    public CredentialIssuer setCredentialEndpoint(String credentialEndpoint) {
        this.credentialEndpoint = credentialEndpoint;
        return this;
    }

    public String getNonceEndpoint() {
        return this.nonceEndpoint;
    }

    public CredentialIssuer setNonceEndpoint(String nonceEndpoint) {
        this.nonceEndpoint = nonceEndpoint;
        return this;
    }

    public String getDeferredCredentialEndpoint() {
        return this.deferredCredentialEndpoint;
    }

    public CredentialIssuer setDeferredCredentialEndpoint(String deferredCredentialEndpoint) {
        this.deferredCredentialEndpoint = deferredCredentialEndpoint;
        return this;
    }

    public List<String> getAuthorizationServers() {
        return this.authorizationServers;
    }

    public CredentialIssuer setAuthorizationServers(List<String> authorizationServers) {
        this.authorizationServers = authorizationServers;
        return this;
    }

    public BatchCredentialIssuance getBatchCredentialIssuance() {
        return this.batchCredentialIssuance;
    }

    public CredentialIssuer setBatchCredentialIssuance(BatchCredentialIssuance batchCredentialIssuance) {
        this.batchCredentialIssuance = batchCredentialIssuance;
        return this;
    }

    public Map<String, SupportedCredentialConfiguration> getCredentialsSupported() {
        return this.credentialsSupported;
    }

    public CredentialIssuer setCredentialsSupported(Map<String, SupportedCredentialConfiguration> credentialsSupported) {
        if (credentialsSupported == null) {
            throw new IllegalArgumentException("credentialsSupported cannot be null");
        }
        this.credentialsSupported = Collections.unmodifiableMap(new HashMap<String, SupportedCredentialConfiguration>(credentialsSupported));
        return this;
    }

    public List<DisplayObject> getDisplay() {
        return this.display;
    }

    public CredentialIssuer setDisplay(List<DisplayObject> display) {
        this.display = display;
        return this;
    }

    public CredentialResponseEncryptionMetadata getCredentialResponseEncryption() {
        return this.credentialResponseEncryption;
    }

    public CredentialIssuer setCredentialResponseEncryption(CredentialResponseEncryptionMetadata credentialResponseEncryption) {
        this.credentialResponseEncryption = credentialResponseEncryption;
        return this;
    }

    public CredentialRequestEncryptionMetadata getCredentialRequestEncryption() {
        return this.credentialRequestEncryption;
    }

    public CredentialIssuer setCredentialRequestEncryption(CredentialRequestEncryptionMetadata credentialRequestEncryption) {
        this.credentialRequestEncryption = credentialRequestEncryption;
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class BatchCredentialIssuance {
        @JsonProperty(value="batch_size")
        private Integer batchSize;

        public Integer getBatchSize() {
            return this.batchSize;
        }

        public BatchCredentialIssuance setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }
    }
}

