/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.returntypes;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.util.Weighted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SampleSummary {
    public static double DEFAULT_PERCENTILE = 0.9;
    public float[][] summaryPoints;
    public float[] relativeWeight;
    public float[][] measure;
    public double weightOfSamples;
    public float[] mean;
    public float[] median;
    public float[] deviation;
    public float[] upper;
    public float[] lower;

    public SampleSummary(int dimensions) {
        this.weightOfSamples = 0.0;
        this.summaryPoints = new float[1][];
        this.summaryPoints[0] = new float[dimensions];
        this.relativeWeight = new float[1];
        this.measure = new float[1][];
        this.measure[0] = new float[dimensions];
        this.median = new float[dimensions];
        this.mean = new float[dimensions];
        this.deviation = new float[dimensions];
        this.upper = new float[dimensions];
        this.lower = new float[dimensions];
    }

    public SampleSummary(float[] point) {
        this(CommonUtils.toDoubleArray(point), 1.0f);
    }

    public SampleSummary(double[] point, float weight) {
        this(point.length);
        this.weightOfSamples = weight;
        this.summaryPoints[0] = CommonUtils.toFloatArray(point);
        this.relativeWeight[0] = weight;
        this.measure[0] = new float[point.length];
        System.arraycopy(this.summaryPoints[0], 0, this.median, 0, point.length);
        System.arraycopy(this.summaryPoints[0], 0, this.mean, 0, point.length);
        System.arraycopy(this.summaryPoints[0], 0, this.upper, 0, point.length);
        System.arraycopy(this.summaryPoints[0], 0, this.lower, 0, point.length);
    }

    void addTypical(float[][] summaryPoints, float[] relativeWeight, float[][] measure) {
        CommonUtils.checkArgument(summaryPoints.length == relativeWeight.length, "incorrect lengths of fields");
        CommonUtils.checkArgument(summaryPoints.length == measure.length, "incorrect lengths of fields");
        if (summaryPoints.length > 0) {
            int dimension = summaryPoints[0].length;
            this.summaryPoints = new float[summaryPoints.length][];
            this.measure = new float[summaryPoints.length][];
            for (int i = 0; i < summaryPoints.length; ++i) {
                CommonUtils.checkArgument(dimension == summaryPoints[i].length, " incorrect length points");
                CommonUtils.checkArgument(dimension == measure[i].length, " incorrect length points");
                this.summaryPoints[i] = Arrays.copyOf(summaryPoints[i], dimension);
                this.measure[i] = Arrays.copyOf(measure[i], dimension);
            }
            this.relativeWeight = Arrays.copyOf(relativeWeight, relativeWeight.length);
        }
    }

    public SampleSummary(List<Weighted<float[]>> points, SampleSummary clusters) {
        this(points, DEFAULT_PERCENTILE);
        this.addTypical(clusters.summaryPoints, clusters.relativeWeight, clusters.measure);
    }

    public SampleSummary(List<Weighted<float[]>> points, float[][] summaryPoints, float[] relativeWeight, float[] measure, double percentile) {
        this(points, percentile);
        float[][] transformedMeasure = new float[measure.length][];
        double factor = 0.0;
        for (int j = 0; j < this.upper.length; ++j) {
            factor += (double)Math.max(0.0f, this.upper[j] - this.lower[j]);
        }
        for (int i = 0; i < measure.length; ++i) {
            transformedMeasure[i] = new float[this.upper.length];
            for (int j = 0; j < this.upper.length; ++j) {
                transformedMeasure[i][j] = factor == 0.0 ? 0.0f : (float)((double)(Math.max(0.0f, this.upper[j] - this.lower[j]) * measure[i]) / factor);
            }
        }
        this.addTypical(summaryPoints, relativeWeight, transformedMeasure);
    }

    public SampleSummary(List<Weighted<float[]>> points, float[][] summaryPoints, float[] relativeWeight, float[] measure) {
        this(points, summaryPoints, relativeWeight, measure, DEFAULT_PERCENTILE);
    }

    public SampleSummary(List<Weighted<float[]>> points) {
        this(points, DEFAULT_PERCENTILE);
    }

    public SampleSummary(List<Weighted<float[]>> points, double percentile) {
        int i;
        CommonUtils.checkArgument(points.size() > 0, "point list cannot be empty");
        CommonUtils.checkArgument(percentile > 0.5, " has to be more than 0.5");
        CommonUtils.checkArgument(percentile < 1.0, "has to be less than 1");
        int dimension = ((float[])points.get((int)0).index).length;
        double[] coordinateSum = new double[dimension];
        double[] coordinateSumSquare = new double[dimension];
        double totalWeight = 0.0;
        for (Weighted<float[]> e2 : points) {
            CommonUtils.checkArgument(((float[])e2.index).length == dimension, "points have to be of same length");
            float weight = e2.weight;
            CommonUtils.checkArgument(!Float.isNaN(weight), " weights must be non-NaN values ");
            CommonUtils.checkArgument(Float.isFinite(weight), " weights must be finite ");
            CommonUtils.checkArgument(weight >= 0.0f, "weights have to be non-negative");
            totalWeight += (double)weight;
            for (int i2 = 0; i2 < dimension; ++i2) {
                int index = i2;
                CommonUtils.checkArgument(!Float.isNaN(((float[])e2.index)[i2]), () -> " improper input, in coordinate " + index + ", must be non-NaN values");
                CommonUtils.checkArgument(Float.isFinite(((float[])e2.index)[i2]), () -> " improper input, in coordinate " + index + ", must be finite values");
                int n = i2;
                coordinateSum[n] = coordinateSum[n] + (double)(((float[])e2.index)[i2] * weight);
                int n2 = i2;
                coordinateSumSquare[n2] = coordinateSumSquare[n2] + (double)(((float[])e2.index)[i2] * ((float[])e2.index)[i2] * weight);
            }
        }
        CommonUtils.checkArgument(totalWeight > 0.0, " weights cannot all be 0");
        this.weightOfSamples = totalWeight;
        this.mean = new float[dimension];
        this.deviation = new float[dimension];
        this.median = new float[dimension];
        this.upper = new float[dimension];
        this.lower = new float[dimension];
        for (i = 0; i < dimension; ++i) {
            this.mean[i] = (float)(coordinateSum[i] / totalWeight);
            this.deviation[i] = (float)Math.sqrt(Math.max(0.0, coordinateSumSquare[i] / totalWeight - (double)(this.mean[i] * this.mean[i])));
        }
        for (i = 0; i < dimension; ++i) {
            int index = i;
            ArrayList list = points.stream().map(e -> new Weighted<Float>(Float.valueOf(((float[])e.index)[index]), e.weight)).collect(Collectors.toCollection(ArrayList::new));
            list.sort((o1, o2) -> Float.compare(((Float)o1.index).floatValue(), ((Float)o2.index).floatValue()));
            this.lower[i] = ((Float)Weighted.prefixPick(list, (double)(totalWeight * (1.0 - percentile))).index).floatValue();
            this.median[i] = ((Float)Weighted.prefixPick(list, (double)(totalWeight / 2.0)).index).floatValue();
            this.upper[i] = ((Float)Weighted.prefixPick(list, (double)(totalWeight * percentile)).index).floatValue();
        }
    }
}

