"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiComboBoxPill = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _badge = require("../../badge");
var _i18n = require("../../i18n");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = (0, _getPrototypeOf2.default)(t); if (r) { var s = (0, _getPrototypeOf2.default)(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return (0, _possibleConstructorReturn2.default)(this, e); }; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiComboBoxPill = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiComboBoxPill, _Component);
  var _super = _createSuper(EuiComboBoxPill);
  function EuiComboBoxPill() {
    var _this;
    (0, _classCallCheck2.default)(this, EuiComboBoxPill);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCloseButtonClick", function () {
      var _this$props = _this.props,
        onClose = _this$props.onClose,
        option = _this$props.option;
      if (onClose) {
        onClose(option);
      }
    });
    return _this;
  }
  (0, _createClass2.default)(EuiComboBoxPill, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props2 = this.props,
        asPlainText = _this$props2.asPlainText,
        children = _this$props2.children,
        className = _this$props2.className,
        color = _this$props2.color,
        onClick = _this$props2.onClick,
        onClickAriaLabel = _this$props2.onClickAriaLabel,
        onClose = _this$props2.onClose,
        option = _this$props2.option,
        rest = (0, _objectWithoutProperties2.default)(_this$props2, ["asPlainText", "children", "className", "color", "onClick", "onClickAriaLabel", "onClose", "option"]);
      var classes = (0, _classnames.default)('euiComboBoxPill', {
        'euiComboBoxPill--plainText': asPlainText
      }, className);
      var onClickProps = onClick && onClickAriaLabel ? {
        onClick: onClick,
        onClickAriaLabel: onClickAriaLabel
      } : {};
      if (onClose) {
        return /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
          token: "euiComboBoxPill.removeSelection",
          default: "Remove {children} from selection in this group",
          values: {
            children: children
          }
        }, function (removeSelection) {
          return /*#__PURE__*/_react.default.createElement(_badge.EuiBadge, (0, _extends2.default)({
            className: classes,
            closeButtonProps: {
              tabIndex: -1
            },
            color: color,
            iconOnClick: _this2.onCloseButtonClick,
            iconOnClickAriaLabel: removeSelection,
            iconSide: "right",
            iconType: "cross",
            title: children
          }, onClickProps, rest), children);
        });
      }
      if (asPlainText) {
        return /*#__PURE__*/_react.default.createElement("span", (0, _extends2.default)({
          className: classes
        }, rest), children);
      }
      return /*#__PURE__*/_react.default.createElement(_badge.EuiBadge, (0, _extends2.default)({
        className: classes,
        color: color,
        title: children
      }, rest, onClickProps), children);
    }
  }]);
  return EuiComboBoxPill;
}(_react.Component);
exports.EuiComboBoxPill = EuiComboBoxPill;
(0, _defineProperty2.default)(EuiComboBoxPill, "defaultProps", {
  color: 'hollow'
});
EuiComboBoxPill.propTypes = {
  asPlainText: _propTypes.default.bool,
  children: _propTypes.default.string,
  className: _propTypes.default.string,
  color: _propTypes.default.string,
  onClick: _propTypes.default.func,
  onClickAriaLabel: _propTypes.default.any,
  onClose: _propTypes.default.func,
  option: _propTypes.default.shape({
    isGroupLabelOption: _propTypes.default.bool,
    label: _propTypes.default.string.isRequired,
    key: _propTypes.default.string,
    options: _propTypes.default.arrayOf(_propTypes.default.shape({
      isGroupLabelOption: _propTypes.default.bool,
      label: _propTypes.default.string.isRequired,
      key: _propTypes.default.string,
      options: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),
      value: _propTypes.default.any,
      className: _propTypes.default.string,
      "aria-label": _propTypes.default.string,
      "data-test-subj": _propTypes.default.string
    }).isRequired),
    value: _propTypes.default.any,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }).isRequired,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};