/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ToolAttributes
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ToolAttributes> {
    @Nonnull
    private final Map<String, JsonData> attributes;
    @Nullable
    private final String inputSchema;
    @Nullable
    private final Boolean strict;
    public static final JsonpDeserializer<ToolAttributes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ToolAttributes::setupToolAttributesDeserializer);

    private ToolAttributes(Builder builder) {
        this.attributes = ApiTypeHelper.unmodifiable(builder.attributes);
        this.inputSchema = builder.inputSchema;
        this.strict = builder.strict;
    }

    public static ToolAttributes of(Function<Builder, ObjectBuilder<ToolAttributes>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, JsonData> attributes() {
        return this.attributes;
    }

    @Nullable
    public final String inputSchema() {
        return this.inputSchema;
    }

    @Nullable
    public final Boolean strict() {
        return this.strict;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, JsonData> item0 : this.attributes.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        if (this.inputSchema != null) {
            generator.writeKey("input_schema");
            generator.write(this.inputSchema);
        }
        if (this.strict != null) {
            generator.writeKey("strict");
            generator.write(this.strict.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupToolAttributesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::inputSchema, JsonpDeserializer.stringDeserializer(), "input_schema");
        op.add(Builder::strict, JsonpDeserializer.booleanDeserializer(), "strict");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (((Builder)builder).attributes == null) {
                ((Builder)builder).attributes = new HashMap();
            }
            ((Builder)builder).attributes.put(name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.attributes);
        result = 31 * result + Objects.hashCode(this.inputSchema);
        result = 31 * result + Objects.hashCode(this.strict);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolAttributes other = (ToolAttributes)o;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.inputSchema, other.inputSchema) && Objects.equals(this.strict, other.strict);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ToolAttributes> {
        @Nullable
        private Map<String, JsonData> attributes;
        @Nullable
        private String inputSchema;
        @Nullable
        private Boolean strict;

        public Builder() {
        }

        private Builder(ToolAttributes o) {
            this.attributes = Builder._mapCopy(o.attributes);
            this.inputSchema = o.inputSchema;
            this.strict = o.strict;
        }

        private Builder(Builder o) {
            this.attributes = Builder._mapCopy(o.attributes);
            this.inputSchema = o.inputSchema;
            this.strict = o.strict;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder attributes(Map<String, JsonData> map) {
            this.attributes = Builder._mapPutAll(this.attributes, map);
            return this;
        }

        @Nonnull
        public final Builder attributes(String key, JsonData value) {
            this.attributes = Builder._mapPut(this.attributes, key, value);
            return this;
        }

        @Nonnull
        public final Builder inputSchema(@Nullable String value) {
            this.inputSchema = value;
            return this;
        }

        @Nonnull
        public final Builder strict(@Nullable Boolean value) {
            this.strict = value;
            return this;
        }

        @Override
        @Nonnull
        public ToolAttributes build() {
            this._checkSingleUse();
            return new ToolAttributes(this);
        }
    }
}

