\name{LabelShapeStatisticsImageFilter}
\alias{LabelShapeStatisticsImageFilter}
\title{LabelShapeStatisticsImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Converts a label image to a label map and valuates the shape
attributes.
LabelShapeStatisticsImageFilter}
\details{
A convenient class that converts a label image to a label map and
valuates the shape attribute at once.
This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
ShapeLabelObject , LabelShapeOpeningImageFilter , LabelStatisticsOpeningImageFilter
itk::LabelImageToShapeLabelMapFilter for the Doxygen on the original ITK class.
LabelShapeStatisticsImageFilter}
%C++ includes: sitkLabelShapeStatisticsImageFilter.h
\section{Methods}{
\describe{
\item{Self ComputeFeretDiameterOff():}{}
\item{Self ComputeFeretDiameterOn():}{
Set the value of ComputeFeretDiameter to true or false respectfully.
}
\item{Self ComputeOrientedBoundingBoxOff():}{}
\item{Self ComputeOrientedBoundingBoxOn():}{
Set the value of ComputeOrientedBoundingBox to true or false
respectfully.
}
\item{Self ComputePerimeterOff():}{}
\item{Self ComputePerimeterOn():}{
Set the value of ComputePerimeter to true or false respectfully.
}
\item{void Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{std::vector< unsigned int > GetBoundingBox(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetCentroid(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{bool GetComputeFeretDiameter() const:}{
Set/Get whether the maximum Feret diameter should be computed or not.
Default value is false, because of the high computation time required.
}
\item{bool GetComputeOrientedBoundingBox() const:}{
Set/Get whether the oriented bounding box should be computed or not.
Default value is false because of potential memory consumption issues
with sparse labels.
}
\item{bool GetComputePerimeter() const:}{
Set/Get whether the perimeter should be computed or not. Default value
is false, because of the high computation time required.
}
\item{double GetElongation(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetEquivalentEllipsoidDiameter(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetEquivalentSphericalPerimeter(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetEquivalentSphericalRadius(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetFeretDiameter(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetFlatness(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< unsigned int > GetIndexes(int64_t label) const:}{
Get an array of indexes for pixels with the label value.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< int64_t > GetLabels() const:}{
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint64_t GetNumberOfLabels():}{
Return the number of labels after execution.
}
\item{uint64_t GetNumberOfPixels(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{uint64_t GetNumberOfPixelsOnBorder(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetOrientedBoundingBoxDirection(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetOrientedBoundingBoxOrigin(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetOrientedBoundingBoxSize(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetOrientedBoundingBoxVertices(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetPerimeter(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetPerimeterOnBorder(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetPerimeterOnBorderRatio(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetPhysicalSize(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetPrincipalAxes(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< double > GetPrincipalMoments(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< unsigned int > GetRegion(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::vector< unsigned int > GetRLEIndexes(int64_t label) const:}{
Get an array of run-length encoding (RLE) indexes for pixels with the
label value. The array is the index of a starting line, followed by
the length repeated. The length of the array is divisible by the
image's dimension + 1. For example for a 2D image the array [ 2, 3, 2]
would encode the two indexes [2,3] and [3,3].
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetRoundness(int64_t label) const:}{
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{bool HasLabel(int64_t label):}{
Does the specified label exist? Can only be called after a call a call
to Update().
}
\item{ LabelShapeStatisticsImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{Self SetComputeFeretDiameter(bool ComputeFeretDiameter):}{
Set/Get whether the maximum Feret diameter should be computed or not.
Default value is false, because of the high computation time required.
}
\item{Self SetComputeOrientedBoundingBox(bool ComputeOrientedBoundingBox):}{
Set/Get whether the oriented bounding box should be computed or not.
Default value is false because of potential memory consumption issues
with sparse labels.
}
\item{Self SetComputePerimeter(bool ComputePerimeter):}{
Set/Get whether the perimeter should be computed or not. Default value
is false, because of the high computation time required.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LabelShapeStatisticsImageFilter():}{
Destructor
}
}
}
