/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination;

import java.util.ArrayList;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageNode;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;

public abstract class PDPageDestination
extends PDDestination {
    protected COSArray array;

    protected PDPageDestination() {
        this.array = new COSArray();
    }

    protected PDPageDestination(COSArray arr) {
        this.array = arr;
    }

    public PDPage getPage() {
        COSBase page;
        PDPage retval = null;
        if (this.array.size() > 0 && (page = this.array.getObject(0)) instanceof COSDictionary) {
            retval = new PDPage((COSDictionary)page);
        }
        return retval;
    }

    public void setPage(PDPage page) {
        this.array.set(0, page);
    }

    public int getPageNumber() {
        COSBase page;
        int retval = -1;
        if (this.array.size() > 0 && (page = this.array.getObject(0)) instanceof COSNumber) {
            retval = ((COSNumber)page).intValue();
        }
        return retval;
    }

    @Deprecated
    public int findPageNumber() {
        int retval = -1;
        if (this.array.size() > 0) {
            COSBase page = this.array.getObject(0);
            if (page instanceof COSNumber) {
                retval = ((COSNumber)page).intValue();
            } else if (page instanceof COSDictionary) {
                COSBase parent = page;
                while (((COSDictionary)parent).getDictionaryObject(COSName.PARENT, COSName.P) != null) {
                    parent = ((COSDictionary)parent).getDictionaryObject(COSName.PARENT, COSName.P);
                }
                PDPageNode pages = new PDPageNode((COSDictionary)parent);
                ArrayList allPages = new ArrayList();
                pages.getAllKids(allPages);
                retval = allPages.indexOf(new PDPage((COSDictionary)page)) + 1;
            }
        }
        return retval;
    }

    public int retrieveDestPageNumber() {
        int retval = -1;
        if (this.array.size() > 0) {
            COSBase page = this.array.getObject(0);
            if (page instanceof COSNumber) {
                retval = ((COSNumber)page).intValue();
            } else if (page instanceof COSDictionary) {
                COSBase parent = page;
                while (((COSDictionary)parent).getDictionaryObject(COSName.PARENT, COSName.P) != null) {
                    parent = ((COSDictionary)parent).getDictionaryObject(COSName.PARENT, COSName.P);
                }
                PDPageNode pages = new PDPageNode((COSDictionary)parent);
                ArrayList allPages = new ArrayList();
                pages.getAllKids(allPages);
                retval = allPages.indexOf(new PDPage((COSDictionary)page));
            }
        }
        return retval;
    }

    public void setPageNumber(int pageNumber) {
        this.array.set(0, pageNumber);
    }

    @Override
    public COSBase getCOSObject() {
        return this.array;
    }

    public COSArray getCOSArray() {
        return this.array;
    }
}

