/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.UploadContext;

public class ServletRequestContext
implements UploadContext {
    private final HttpServletRequest request;

    public ServletRequestContext(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }

    @Override
    public long contentLength() {
        long l;
        try {
            l = Long.parseLong(this.request.getHeader("Content-length"));
        }
        catch (NumberFormatException numberFormatException) {
            l = this.request.getContentLength();
        }
        return l;
    }

    @Override
    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    @Override
    public String getContentType() {
        return this.request.getContentType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public String toString() {
        return String.format("ContentLength=%s, ContentType=%s", this.contentLength(), this.getContentType());
    }
}

