"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLanguageService = getLanguageService;
const pugDocument_1 = require("./pugDocument");
const completion_1 = require("./services/completion");
const documentHighlight_1 = require("./services/documentHighlight");
const documentLinks_1 = require("./services/documentLinks");
const hover_1 = require("./services/hover");
const scanner_1 = require("./services/scanner");
const selectionRanges_1 = require("./services/selectionRanges");
const foldingRanges_1 = require("./services/foldingRanges");
const quoteComplete_1 = require("./services/quoteComplete");
__exportStar(require("./baseParse"), exports);
function getLanguageService(htmlLs) {
    return {
        parsePugDocument: (0, pugDocument_1.register)(htmlLs),
        doComplete: (0, completion_1.register)(htmlLs),
        findDocumentHighlights: (0, documentHighlight_1.register)(htmlLs),
        findDocumentLinks: (0, documentLinks_1.register)(htmlLs),
        doHover: (0, hover_1.register)(htmlLs),
        createScanner: (0, scanner_1.register)(htmlLs),
        getSelectionRanges: (0, selectionRanges_1.register)(htmlLs),
        doQuoteComplete: (0, quoteComplete_1.register)(htmlLs),
        getFoldingRanges: (0, foldingRanges_1.register)(),
    };
}
//# sourceMappingURL=languageService.js.map