﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudtrail/CloudTrail_EXPORTS.h>
#include <aws/cloudtrail/model/Tag.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CloudTrail {
namespace Model {

/**
 * <p>A resource tag.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ResourceTag">AWS
 * API Reference</a></p>
 */
class ResourceTag {
 public:
  AWS_CLOUDTRAIL_API ResourceTag() = default;
  AWS_CLOUDTRAIL_API ResourceTag(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDTRAIL_API ResourceTag& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDTRAIL_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Specifies the ARN of the resource.</p>
   */
  inline const Aws::String& GetResourceId() const { return m_resourceId; }
  inline bool ResourceIdHasBeenSet() const { return m_resourceIdHasBeenSet; }
  template <typename ResourceIdT = Aws::String>
  void SetResourceId(ResourceIdT&& value) {
    m_resourceIdHasBeenSet = true;
    m_resourceId = std::forward<ResourceIdT>(value);
  }
  template <typename ResourceIdT = Aws::String>
  ResourceTag& WithResourceId(ResourceIdT&& value) {
    SetResourceId(std::forward<ResourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of tags.</p>
   */
  inline const Aws::Vector<Tag>& GetTagsList() const { return m_tagsList; }
  inline bool TagsListHasBeenSet() const { return m_tagsListHasBeenSet; }
  template <typename TagsListT = Aws::Vector<Tag>>
  void SetTagsList(TagsListT&& value) {
    m_tagsListHasBeenSet = true;
    m_tagsList = std::forward<TagsListT>(value);
  }
  template <typename TagsListT = Aws::Vector<Tag>>
  ResourceTag& WithTagsList(TagsListT&& value) {
    SetTagsList(std::forward<TagsListT>(value));
    return *this;
  }
  template <typename TagsListT = Tag>
  ResourceTag& AddTagsList(TagsListT&& value) {
    m_tagsListHasBeenSet = true;
    m_tagsList.emplace_back(std::forward<TagsListT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_resourceId;

  Aws::Vector<Tag> m_tagsList;
  bool m_resourceIdHasBeenSet = false;
  bool m_tagsListHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudTrail
}  // namespace Aws
