/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.mpxj.Day;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Notes;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.common.AutoCloseableHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.ResultSetHelper;
import net.sf.mpxj.primavera.MapRow;
import net.sf.mpxj.primavera.PrimaveraReader;
import net.sf.mpxj.primavera.ResultSetRow;
import net.sf.mpxj.primavera.Row;
import net.sf.mpxj.primavera.StructuredTextParser;
import net.sf.mpxj.primavera.StructuredTextRecord;
import net.sf.mpxj.primavera.UserFieldCounters;
import net.sf.mpxj.primavera.UserFieldDataType;
import net.sf.mpxj.reader.AbstractProjectReader;

public final class PrimaveraDatabaseReader
extends AbstractProjectReader {
    private PrimaveraReader m_reader;
    private Integer m_projectID;
    private String m_schema = "";
    private DataSource m_dataSource;
    private Connection m_connection;
    private boolean m_allocatedConnection;
    private final UserFieldCounters m_taskUdfCounters = new UserFieldCounters();
    private final UserFieldCounters m_resourceUdfCounters = new UserFieldCounters();
    private final UserFieldCounters m_assignmentUdfCounters = new UserFieldCounters();
    private boolean m_matchPrimaveraWBS = true;
    private boolean m_wbsIsFullPath = true;
    private final Map<FieldType, String> m_resourceFields = PrimaveraReader.getDefaultResourceFieldMap();
    private final Map<FieldType, String> m_roleFields = PrimaveraReader.getDefaultRoleFieldMap();
    private final Map<FieldType, String> m_wbsFields = PrimaveraReader.getDefaultWbsFieldMap();
    private final Map<FieldType, String> m_taskFields = PrimaveraReader.getDefaultTaskFieldMap();
    private final Map<FieldType, String> m_assignmentFields = PrimaveraReader.getDefaultAssignmentFieldMap();

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            List<Row> rows = this.getRows("select proj_id, proj_short_name from " + this.m_schema + "project where delete_date is null");
            for (Row row : rows) {
                Integer id = row.getInteger("proj_id");
                String name = row.getString("proj_short_name");
                result.put(id, name);
            }
            return result;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    public ProjectFile read() throws MPXJException {
        try {
            this.m_reader = new PrimaveraReader(this.m_taskUdfCounters, this.m_resourceUdfCounters, this.m_assignmentUdfCounters, this.m_resourceFields, this.m_roleFields, this.m_wbsFields, this.m_taskFields, this.m_assignmentFields, this.m_matchPrimaveraWBS, this.m_wbsIsFullPath);
            ProjectFile project = this.m_reader.getProject();
            this.addListenersToProject(project);
            this.processAnalytics();
            this.processProjectProperties();
            this.processActivityCodes();
            this.processUserDefinedFields();
            this.processExpenseCategories();
            this.processCostAccounts();
            this.processCalendars();
            this.processResources();
            this.processRoles();
            this.processResourceRates();
            this.processRoleRates();
            this.processTasks();
            this.processPredecessors();
            this.processWorkContours();
            this.processAssignments();
            this.processExpenseItems();
            this.m_reader.rollupValues();
            this.m_reader = null;
            project.updateStructure();
            ProjectFile projectFile = project;
            return projectFile;
        }
        catch (SQLException ex) {
            throw new MPXJException("Error reading file", ex);
        }
        finally {
            if (this.m_allocatedConnection) {
                AutoCloseableHelper.closeQuietly(this.m_connection);
                this.m_connection = null;
            }
        }
    }

    public List<ProjectFile> readAll() throws MPXJException {
        Map<Integer, String> projects = this.listProjects();
        ArrayList<ProjectFile> result = new ArrayList<ProjectFile>(projects.keySet().size());
        for (Integer id : projects.keySet()) {
            this.setProjectID(id);
            result.add(this.read());
        }
        return result;
    }

    private void processAnalytics() throws SQLException {
        this.allocateConnection();
        DatabaseMetaData meta = this.m_connection.getMetaData();
        String productName = meta.getDatabaseProductName();
        productName = productName == null || productName.isEmpty() ? "DATABASE" : productName.toUpperCase();
        ProjectProperties properties = this.m_reader.getProject().getProjectProperties();
        properties.setFileApplication("Primavera");
        properties.setFileType(productName);
    }

    private void processProjectProperties() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "project where proj_id=?", this.m_projectID);
        this.m_reader.processProjectProperties(rows);
        rows = this.getRows("select * from " + this.m_schema + "prefer where prefer.delete_date is null");
        if (!rows.isEmpty()) {
            Row row = rows.get(0);
            ProjectProperties ph = this.m_reader.getProject().getProjectProperties();
            ph.setCreationDate(row.getDate("create_date"));
            ph.setLastSaved(row.getDate("update_date"));
            ph.setMinutesPerDay((int)(row.getDouble("day_hr_cnt") * 60.0));
            ph.setMinutesPerWeek((int)(row.getDouble("week_hr_cnt") * 60.0));
            ph.setMinutesPerMonth((int)(row.getDouble("month_hr_cnt") * 60.0));
            ph.setMinutesPerYear((int)(row.getDouble("year_hr_cnt") * 60.0));
            ph.setWeekStartDay(Day.getInstance(row.getInt("week_start_day_num")));
            this.processDefaultCurrency(row.getInteger("curr_id"));
        }
        this.processSchedulingProjectProperties();
    }

    private void processExpenseCategories() throws SQLException {
        this.m_reader.processExpenseCategories(this.getRows("select * from " + this.m_schema + "costtype"));
    }

    private void processExpenseItems() throws SQLException {
        this.m_reader.processExpenseItems(this.getRows("select * from " + this.m_schema + "projcost where proj_id=?", this.m_projectID));
    }

    private void processCostAccounts() throws SQLException {
        this.m_reader.processCostAccounts(this.getRows("select * from " + this.m_schema + "account"));
    }

    private void processActivityCodes() throws SQLException {
        List<Row> types = this.getRows("select * from " + this.m_schema + "actvtype where actv_code_type_id in (select distinct actv_code_type_id from taskactv where proj_id=?)", this.m_projectID);
        List<Row> typeValues = this.getRows("select * from " + this.m_schema + "actvcode where actv_code_id in (select distinct actv_code_id from taskactv where proj_id=?)", this.m_projectID);
        List<Row> assignments = this.getRows("select * from " + this.m_schema + "taskactv where proj_id=?", this.m_projectID);
        this.m_reader.processActivityCodes(types, typeValues, assignments);
    }

    private void processUserDefinedFields() throws SQLException {
        List<Row> fields = this.getRows("select * from " + this.m_schema + "udftype");
        List<Row> values = this.getRows("select * from " + this.m_schema + "udfvalue where proj_id=? or proj_id is null", this.m_projectID);
        this.m_reader.processUserDefinedFields(fields, values);
    }

    private void processSchedulingProjectProperties() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "projprop where proj_id=? and prop_name='scheduling'", this.m_projectID);
        if (!rows.isEmpty()) {
            StructuredTextRecord record = new StructuredTextParser().parse(rows.get(0).getString("prop_value"));
            this.m_reader.processScheduleOptions(new MapRow(new HashMap<String, Object>(record.getAttributes())));
        }
    }

    private void processDefaultCurrency(Integer currencyID) throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "currtype where curr_id=?", currencyID);
        if (!rows.isEmpty()) {
            Row row = rows.get(0);
            this.m_reader.processDefaultCurrency(row);
        }
    }

    private void processResources() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "rsrc where delete_date is null and rsrc_id in (select rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null) order by rsrc_seq_num", this.m_projectID);
        this.m_reader.processResources(rows);
    }

    private void processRoles() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "roles where delete_date is null and role_id in (select role_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null) order by seq_num", this.m_projectID);
        this.m_reader.processRoles(rows);
    }

    private void processResourceRates() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "rsrcrate where delete_date is null and rsrc_id in (select rsrc_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null) order by rsrc_rate_id", this.m_projectID);
        this.m_reader.processResourceRates(rows);
    }

    private void processRoleRates() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "rolerate where delete_date is null and role_id in (select role_id from " + this.m_schema + "taskrsrc t where proj_id=? and delete_date is null) order by role_rate_id", this.m_projectID);
        this.m_reader.processRoleRates(rows);
    }

    private void processTasks() throws SQLException {
        List<Row> wbs = this.getRows("select * from " + this.m_schema + "projwbs where proj_id=? and delete_date is null order by parent_wbs_id,seq_num", this.m_projectID);
        List<Row> tasks = this.getRows("select * from " + this.m_schema + "task where proj_id=? and delete_date is null", this.m_projectID);
        Map<Integer, String> topics = this.m_reader.getNotebookTopics(this.getRows("select * from " + this.m_schema + "memotype"));
        Map<Integer, Notes> wbsNotes = this.m_reader.getNotes(topics, this.getRows("select * from " + this.m_schema + "wbsmemo where proj_id=?", this.m_projectID), "wbs_id", "wbs_memo");
        Map<Integer, Notes> taskNotes = this.m_reader.getNotes(topics, this.getRows("select * from " + this.m_schema + "taskmemo where proj_id=?", this.m_projectID), "task_id", "task_memo");
        this.m_reader.processTasks(wbs, tasks, wbsNotes, taskNotes);
    }

    private void processPredecessors() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "taskpred where proj_id=? and delete_date is null", this.m_projectID);
        this.m_reader.processPredecessors(rows);
    }

    private void processCalendars() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "calendar where (proj_id is null or proj_id=?) and delete_date is null", this.m_projectID);
        this.m_reader.processCalendars(rows);
    }

    private void processAssignments() throws SQLException {
        List<Row> rows = this.getRows("select * from " + this.m_schema + "taskrsrc where proj_id=? and delete_date is null", this.m_projectID);
        this.m_reader.processAssignments(rows, this.processWorkContours());
    }

    private Map<Integer, WorkContour> processWorkContours() throws SQLException {
        HashMap<Integer, WorkContour> result = new HashMap<Integer, WorkContour>();
        List<Row> rows = this.getRows("select * from " + this.m_schema + "rsrccurv");
        for (Row row : rows) {
            try {
                String name = row.getString("curv_name");
                double[] values = new StructuredTextParser().parse(row.getString("curv_data")).getChildren().stream().mapToDouble(r -> Double.parseDouble(r.getAttribute("PctUsage"))).toArray();
                result.put(row.getInteger("curv_id"), new WorkContour(name, values));
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }

    @Override
    public ProjectFile read(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ProjectFile> readAll(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectFile read(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ProjectFile> readAll(File file) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProjectFile read(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    /*
     * Exception decompiling
     */
    private List<Row> getRows(String sql) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Row> getRows(String sql, Integer var) throws SQLException {
        this.allocateConnection();
        ArrayList<Row> result = new ArrayList<Row>();
        try (PreparedStatement ps = this.m_connection.prepareStatement(sql);){
            ps.setInt(1, NumberHelper.getInt(var));
            try (ResultSet rs = ps.executeQuery();){
                Map<String, Integer> meta = ResultSetHelper.populateMetaData(rs);
                while (rs.next()) {
                    result.add(new ResultSetRow(rs, meta));
                }
            }
        }
        return result;
    }

    private void allocateConnection() throws SQLException {
        if (this.m_connection == null) {
            this.m_connection = this.m_dataSource.getConnection();
            this.m_allocatedConnection = true;
        }
    }

    public void setSchema(String schema) {
        if (schema == null) {
            schema = "";
        } else if (!schema.isEmpty() && !schema.endsWith(".")) {
            schema = schema + '.';
        }
        this.m_schema = schema;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public void setFieldNamesForTaskUdfType(UserFieldDataType type, String[] fieldNames) {
        this.m_taskUdfCounters.setFieldNamesForType(type, fieldNames);
    }

    public void setFieldNamesForResourceUdfType(UserFieldDataType type, String[] fieldNames) {
        this.m_resourceUdfCounters.setFieldNamesForType(type, fieldNames);
    }

    public void setFieldNamesForAssignmentUdfType(UserFieldDataType type, String[] fieldNames) {
        this.m_assignmentUdfCounters.setFieldNamesForType(type, fieldNames);
    }

    public Map<FieldType, String> getResourceFieldMap() {
        return this.m_resourceFields;
    }

    public Map<FieldType, String> getRoleFieldMap() {
        return this.m_roleFields;
    }

    public Map<FieldType, String> getWbsFieldMap() {
        return this.m_wbsFields;
    }

    public Map<FieldType, String> getActivityFieldMap() {
        return this.m_taskFields;
    }

    public Map<FieldType, String> getAssignmentFieldMap() {
        return this.m_assignmentFields;
    }

    public boolean getMatchPrimaveraWBS() {
        return this.m_matchPrimaveraWBS;
    }

    public void setMatchPrimaveraWBS(boolean matchPrimaveraWBS) {
        this.m_matchPrimaveraWBS = matchPrimaveraWBS;
    }

    public boolean getWbsIsFullPath() {
        return this.m_wbsIsFullPath;
    }

    public void setWbsIsFullPath(boolean wbsIsFullPath) {
        this.m_wbsIsFullPath = wbsIsFullPath;
    }
}

