/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.ddl;

import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryModelContent;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableDataModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryTableDropModel
extends SQLQueryModelContent {
    @Nullable
    private final List<SQLQueryRowsTableDataModel> tables;
    private final boolean isView;
    private final boolean ifExists;

    @NotNull
    public static SQLQueryModelContent recognize(@NotNull SQLQueryModelRecognizer recognizer, @NotNull STMTreeNode node, boolean isView) {
        List<SQLQueryRowsTableDataModel> tables = node.findChildrenOfName(STMKnownRuleNames.tableName).stream().map(n -> recognizer.collectTableReference((STMTreeNode)n, true)).collect(Collectors.toList());
        boolean ifExists = node.findFirstChildOfName(STMKnownRuleNames.ifExistsSpec) != null;
        return new SQLQueryTableDropModel(node, tables, ifExists, isView);
    }

    private SQLQueryTableDropModel(@NotNull STMTreeNode syntaxNode, @Nullable List<SQLQueryRowsTableDataModel> tables, boolean ifExists, boolean isView) {
        super(syntaxNode.getRealInterval(), syntaxNode, new SQLQueryNodeModel[0]);
        this.tables = tables;
        this.ifExists = ifExists;
        this.isView = isView;
    }

    @Nullable
    public List<SQLQueryRowsTableDataModel> getTables() {
        return this.tables;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public boolean isView() {
        return this.isView;
    }

    @Override
    public void resolveObjectAndRowsReferences(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.tables != null) {
            if (this.ifExists) {
                statistics.setTreatErrorAsWarnings(true);
            }
            this.tables.forEach(t -> t.resolveObjectAndRowsReferences(context, statistics));
            if (this.ifExists) {
                statistics.setTreatErrorAsWarnings(false);
            }
        }
    }

    @Override
    public void resolveValueRelations(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        if (this.tables != null) {
            if (this.ifExists) {
                statistics.setTreatErrorAsWarnings(true);
            }
            this.tables.forEach(t -> t.resolveValueRelations(context, statistics));
            if (this.ifExists) {
                statistics.setTreatErrorAsWarnings(false);
            }
        }
    }

    @Override
    @Nullable
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitTableStatementDrop(this, arg);
    }
}

