/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.colorprovider.BackgroundPainterColorProvider;
import net.infonode.gui.colorprovider.ColorMultiplier;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.ColorProviderUtil;
import net.infonode.util.Direction;

public class HighlightBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Insets INSETS = new Insets(1, 1, 0, 0);
    private boolean lowered;
    private boolean pressed;
    private ColorProvider colorProvider;

    public HighlightBorder() {
        this(false);
    }

    public HighlightBorder(boolean lowered) {
        this(lowered, null);
    }

    public HighlightBorder(boolean lowered, Color color) {
        this(lowered, false, color);
    }

    public HighlightBorder(boolean lowered, boolean pressed, Color color) {
        this(lowered, pressed, ColorProviderUtil.getColorProvider(color, new ColorMultiplier(BackgroundPainterColorProvider.INSTANCE, lowered ? 0.7 : 1.7)));
    }

    public HighlightBorder(boolean lowered, boolean pressed, ColorProvider colorProvider) {
        this.lowered = lowered;
        this.pressed = pressed;
        this.colorProvider = colorProvider;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.pressed ? InsetsUtil.rotate(Direction.LEFT, INSETS) : INSETS;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.colorProvider.getColor(c));
        if (this.pressed) {
            GraphicsUtil.drawOptimizedLine(g, x + (this.lowered ? 0 : 1), y + height - 1, x + width - 1, y + height - 1);
            GraphicsUtil.drawOptimizedLine(g, x + width - 1, y + (this.lowered ? 0 : 1), x + width - 1, y + height - 2);
        } else {
            GraphicsUtil.drawOptimizedLine(g, x, y, x + width - (this.lowered ? 1 : 2), y);
            GraphicsUtil.drawOptimizedLine(g, x, y, x, y + height - (this.lowered ? 1 : 2));
        }
    }
}

