/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.bugreport;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;

public class BugFormatter
extends Formatter {
    private static final Pattern FILE_NOT_FOUND = Pattern.compile("(?<=java\\.io\\.FileNotFoundException:).*");

    @Override
    public String format(LogRecord record) {
        String message = record.getMessage();
        StringBuilder sb = new StringBuilder();
        sb.append(FILE_NOT_FOUND.matcher(message).replaceAll("---"));
        sb.append('\n');
        if (record.getThrown() != null) {
            try (StringWriter sw = new StringWriter();
                 PrintWriter pw = new PrintWriter(sw);){
                record.getThrown().printStackTrace(pw);
                String stackTrace = sw.toString();
                sb.append(FILE_NOT_FOUND.matcher(stackTrace).replaceAll("---"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

