/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.io.File;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.function.settings.SaveConfig;

public class MigrateConfig
extends GenericFunction {
    private final File _targetFile;

    public MigrateConfig(App app, File file) {
        super(app);
        this._targetFile = file;
    }

    @Override
    public String getNameKey() {
        return "function.migrateconfig";
    }

    @Override
    public void begin() {
        if (this._targetFile == null) {
            return;
        }
        if (this.getConfig().getConfigBoolean("prune.configmigrationasked")) {
            return;
        }
        File file = this.getConfig().getConfigFile();
        String string = file.getAbsolutePath();
        String string2 = this._targetFile.getAbsolutePath();
        String string3 = I18nManager.getText("dialog.migrateconfig.confirm", string, string2);
        int n = JOptionPane.showConfirmDialog(this._app.getFrame(), string3, this.getName(), 1);
        if (n == 2 || n == -1) {
            return;
        }
        if (n == 0) {
            File file2 = this._targetFile.getAbsoluteFile().getParentFile();
            if (file2 != null && (file2.isFile() || !file2.exists() && !file2.mkdirs())) {
                String string4 = I18nManager.getText("error.migrateconfig.couldnotcreatedirectory", file2.getAbsolutePath());
                this._app.showErrorMessageNoLookup(this.getNameKey(), string4);
                return;
            }
            this.getConfig().setConfigFile(this._targetFile);
            SaveConfig saveConfig = new SaveConfig(this._app);
            if (!saveConfig.silentSave()) {
                return;
            }
            if (!this.deleteFile(file)) {
                String string5 = I18nManager.getText("error.migrateconfig.couldnotdeletefile", file.getAbsolutePath());
                this._app.showErrorMessageNoLookup(this.getNameKey(), string5);
            }
        } else {
            this.getConfig().setConfigBoolean("prune.configmigrationasked", true);
            new SaveConfig(this._app).silentSave();
        }
    }

    private boolean deleteFile(File file) {
        return file == null || !file.exists() || file.delete();
    }
}

