/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;

class ChannelsPropsPane
extends JPanel {
    private final JCheckBox checkShowChannelNumbering = new JCheckBox(FantasiaI18n.i18n.getLabel("ChannelsPropsPane.checkShowChannelNumbering"));
    private final JCheckBox checkShowMidiInfo = new JCheckBox(FantasiaI18n.i18n.getLabel("ChannelsPropsPane.checkShowMidiInfo"));
    private final JCheckBox checkShowStreamVoiceCount = new JCheckBox(FantasiaI18n.i18n.getLabel("ChannelsPropsPane.checkShowStreamVoiceCount"));
    private final JLabel lChannelLaneNumber = new JLabel(FantasiaI18n.i18n.getLabel("ChannelsPropsPane.lChannelLaneNumber"));
    private JSpinner spChannelLaneNumber;

    ChannelsPropsPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createChannelLanesPane());
        this.add(this.createSmallViewPane());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.add(jPanel);
    }

    protected void apply() {
        boolean bl = this.checkShowChannelNumbering.isSelected();
        FantasiaPrefs.preferences().setBoolProperty("channel.smallView.showChannelNumbering", bl);
        bl = this.checkShowMidiInfo.isSelected();
        FantasiaPrefs.preferences().setBoolProperty("channel.smallView.showMidiInfo", bl);
        bl = this.checkShowStreamVoiceCount.isSelected();
        FantasiaPrefs.preferences().setBoolProperty("channel.smallView.showStreamVoiceCount", bl);
        int n = Integer.parseInt(this.spChannelLaneNumber.getValue().toString());
        FantasiaPrefs.preferences().setIntProperty("channelLanes.count", n);
    }

    private JPanel createSmallViewPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        boolean bl = FantasiaPrefs.preferences().getBoolProperty("channel.smallView.showChannelNumbering");
        this.checkShowChannelNumbering.setSelected(bl);
        this.checkShowChannelNumbering.setAlignmentX(0.0f);
        jPanel.add(this.checkShowChannelNumbering);
        bl = FantasiaPrefs.preferences().getBoolProperty("channel.smallView.showMidiInfo");
        this.checkShowMidiInfo.setSelected(bl);
        this.checkShowMidiInfo.setAlignmentX(0.0f);
        jPanel.add(this.checkShowMidiInfo);
        bl = FantasiaPrefs.preferences().getBoolProperty("channel.smallView.showStreamVoiceCount");
        this.checkShowStreamVoiceCount.setSelected(bl);
        this.checkShowStreamVoiceCount.setAlignmentX(0.0f);
        jPanel.add(this.checkShowStreamVoiceCount);
        String string = FantasiaI18n.i18n.getLabel("ChannelsPropsPane.smallView");
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        jPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, jPanel.getPreferredSize().height));
        return jPanel;
    }

    private JPanel createChannelLanesPane() {
        int n = 8;
        int n2 = FantasiaPrefs.preferences().getIntProperty("channelLanes.count");
        if (n2 < 1 || n2 > n) {
            n2 = n;
        }
        this.spChannelLaneNumber = new JSpinner(new SpinnerNumberModel(n2, 1, n, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.lChannelLaneNumber);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.spChannelLaneNumber);
        jPanel.setAlignmentX(0.0f);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        String string = FantasiaI18n.i18n.getLabel("ChannelsPropsPane.channelLanes");
        jPanel2.setBorder(BorderFactory.createTitledBorder(string));
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, jPanel.getPreferredSize().height));
        jPanel2.add(jPanel);
        jPanel2.setAlignmentX(0.0f);
        return jPanel2;
    }
}

