/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.auth.callback.SecurityIdentityCallback;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.sasl._private.ElytronMessages;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServer;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;

public final class SecurityIdentitySaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    public SecurityIdentitySaslServerFactory(SaslServerFactory delegate) {
        super(delegate);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, final CallbackHandler cbh) throws SaslException {
        SaslServer delegateSaslServer = this.delegate.createSaslServer(mechanism, protocol, serverName, props, cbh);
        return delegateSaslServer == null ? null : new AbstractDelegatingSaslServer(delegateSaslServer){
            private final AtomicBoolean complete;
            private volatile SecurityIdentity securityIdentity;
            {
                super(delegate);
                this.complete = new AtomicBoolean();
            }

            @Override
            public byte[] evaluateResponse(byte[] response) throws SaslException {
                byte[] challenge = this.delegate.evaluateResponse(response);
                if (this.isComplete() && this.complete.compareAndSet(false, true)) {
                    try {
                        SecurityIdentityCallback ric = new SecurityIdentityCallback();
                        cbh.handle(new Callback[]{ric});
                        this.securityIdentity = ric.getSecurityIdentity();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return challenge;
            }

            @Override
            public Object getNegotiatedProperty(String propName) {
                if (!this.isComplete()) {
                    throw ElytronMessages.sasl.mechAuthenticationNotComplete();
                }
                return propName.equals("wildfly.sasl.security-identity") ? this.securityIdentity : super.getNegotiatedProperty(propName);
            }

            @Override
            public void dispose() throws SaslException {
                try {
                    super.dispose();
                }
                finally {
                    this.securityIdentity = null;
                }
            }
        };
    }
}

