/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.jdbc.internal;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

final class ResultSetsSet {
    private ResultSet first;
    private HashMap<ResultSet, ResultSet> more;

    ResultSetsSet() {
    }

    void forEachResultSet(Consumer<ResultSet> action) {
        if (this.first != null) {
            action.accept(this.first);
            if (this.more != null) {
                this.more.keySet().forEach(action);
            }
        }
    }

    void storeResultSet(ResultSet resultSet) {
        if (this.first == null) {
            this.first = resultSet;
        } else if (this.first != resultSet) {
            if (this.more == null) {
                this.more = new HashMap();
            }
            this.more.put(resultSet, resultSet);
        }
    }

    boolean isEmpty() {
        return this.first == null;
    }

    ResultSet removeResultSet(ResultSet resultSet) {
        if (this.first == resultSet) {
            ResultSet v = this.first;
            this.first = null;
            this.scaleDown();
            return v;
        }
        if (this.more != null) {
            return this.more.remove(resultSet);
        }
        return null;
    }

    private void scaleDown() {
        if (this.more != null && !this.more.isEmpty()) {
            Iterator<Map.Entry<ResultSet, ResultSet>> iterator = this.more.entrySet().iterator();
            Map.Entry<ResultSet, ResultSet> entry = iterator.next();
            ResultSet resultSet = entry.getKey();
            iterator.remove();
            this.first = resultSet;
        }
    }

    void clear() {
        this.first = null;
        if (this.more != null) {
            this.more.clear();
            this.more = null;
        }
    }
}

