/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.spi;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;

public interface BeanFactory<T> {
    public BeanInstance<T> createInstance();

    public static interface BeanInstance<T>
    extends AutoCloseable {
        public T getInstance();

        @Override
        public void close();

        public static class ClosingTask<T>
        implements Closeable {
            private final Collection<BeanInstance<T>> instances;

            public ClosingTask(Collection<BeanInstance<T>> instances) {
                this.instances = instances;
            }

            @Override
            public void close() throws IOException {
                for (BeanInstance<T> i : this.instances) {
                    i.close();
                }
            }
        }
    }
}

