/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Executor;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.NTFRegistration;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

class NTFDCNRegistration
extends NTFRegistration
implements DatabaseChangeRegistration {
    private final long regid;
    private final byte[][] contextArr;
    private final String clientId;
    private final boolean isClientInitiated;
    private String[] tables = new String[10];
    private int nbOfStringsInTable = 0;

    NTFDCNRegistration(int _internalId, boolean _jdbcGetsNotification, String _dbName, long _regid, String _username, String _clientHost, int _clientTCPPort, @Blind(value=PropertiesBlinder.class) Properties _options, short _dbVersionNumber, Exception[] _connectionCreationExceptionArr, byte[][] contextArr, String clientId, boolean isClientInitiated) {
        super(_internalId, 2, _jdbcGetsNotification, _dbName, _clientHost, _clientTCPPort, _options, _username, _dbVersionNumber, _connectionCreationExceptionArr);
        this.regid = _regid;
        this.contextArr = contextArr;
        this.clientId = clientId;
        this.isClientInitiated = isClientInitiated;
    }

    NTFDCNRegistration(String _dbName, long _regid, String _username, short _databaseVersionNumber) {
        super(0, 2, false, _dbName, null, 0, null, _username, _databaseVersionNumber, null);
        this.regid = _regid;
        this.contextArr = null;
        this.clientId = null;
        this.isClientInitiated = false;
    }

    public boolean isClientInitiated() {
        return this.isClientInitiated;
    }

    public byte[][] getContext() {
        return this.contextArr;
    }

    public String getClientId() {
        return this.clientId;
    }

    @Override
    public int getRegistrationId() {
        return (int)this.regid;
    }

    @Override
    public long getRegId() {
        return this.regid;
    }

    @Override
    public void addListener(DatabaseChangeListener l, Executor e) throws SQLException {
        NTFEventListener listener = new NTFEventListener(l);
        listener.setExecutor(e);
        this.addListener(listener);
    }

    @Override
    public void addListener(DatabaseChangeListener l) throws SQLException {
        NTFEventListener listener = new NTFEventListener(l);
        this.addListener(listener);
    }

    @Override
    public void removeListener(DatabaseChangeListener l) throws SQLException {
        super.removeListener(l);
    }

    void addTablesName(String[] _tables, int _nbOfString) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.nbOfStringsInTable + _nbOfString > this.tables.length) {
                String[] tempArr = new String[(this.nbOfStringsInTable + _nbOfString) * 2];
                System.arraycopy(this.tables, 0, tempArr, 0, this.tables.length);
                this.tables = tempArr;
            }
            System.arraycopy(_tables, 0, this.tables, this.nbOfStringsInTable, _nbOfString);
            this.nbOfStringsInTable += _nbOfString;
        }
    }

    @Override
    public String[] getTables() {
        String[] ret = new String[this.nbOfStringsInTable];
        System.arraycopy(this.tables, 0, ret, 0, this.nbOfStringsInTable);
        return ret;
    }
}

