/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Comparator;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.ArrayUtil;

final class ComponentTree
implements Component2D {
    private static final Comparator<Component2D> X_COMPARATOR = Comparator.comparingDouble(Component2D::getMinX).thenComparingDouble(Component2D::getMaxX);
    private static final Comparator<Component2D> Y_COMPARATOR = Comparator.comparingDouble(Component2D::getMinY).thenComparingDouble(Component2D::getMaxY);
    private static final boolean ROOT_SPLITX = false;
    private double minY;
    private double maxY;
    private double minX;
    private double maxX;
    private ComponentTree left;
    private ComponentTree right;
    private final Component2D component;

    private ComponentTree(Component2D component) {
        this.minY = component.getMinY();
        this.maxY = component.getMaxY();
        this.minX = component.getMinX();
        this.maxX = component.getMaxX();
        this.component = component;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(x, y, false);
    }

    private boolean contains(double x, double y, boolean splitX) {
        if (y <= this.maxY && x <= this.maxX) {
            if (this.component.contains(x, y)) {
                return true;
            }
            if (this.left != null && this.left.contains(x, y, !splitX)) {
                return true;
            }
            if (this.right != null && (!splitX && y >= this.component.getMinY() || splitX && x >= this.component.getMinX())) {
                return this.right.contains(x, y, !splitX);
            }
        }
        return false;
    }

    @Override
    public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        return this.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY, false);
    }

    private boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, boolean splitX) {
        if (minY <= this.maxY && minX <= this.maxX) {
            if (this.component.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY)) {
                return true;
            }
            if (this.left != null && this.left.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY, !splitX)) {
                return true;
            }
            if (this.right != null && (!splitX && maxY >= this.component.getMinY() || splitX && maxX >= this.component.getMinX())) {
                return this.right.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY, !splitX);
            }
        }
        return false;
    }

    @Override
    public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        return this.intersectsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, false);
    }

    private boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY, boolean splitX) {
        if (minY <= this.maxY && minX <= this.maxX) {
            if (this.component.intersectsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY)) {
                return true;
            }
            if (this.left != null && this.left.intersectsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, !splitX)) {
                return true;
            }
            if (this.right != null && (!splitX && maxY >= this.component.getMinY() || splitX && maxX >= this.component.getMinX())) {
                return this.right.intersectsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, !splitX);
            }
        }
        return false;
    }

    @Override
    public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        return this.containsLine(minX, maxX, minY, maxY, aX, aY, bX, bY, false);
    }

    private boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, boolean splitX) {
        if (minY <= this.maxY && minX <= this.maxX) {
            if (this.component.containsLine(minX, maxX, minY, maxY, aX, aY, bX, bY)) {
                return true;
            }
            if (this.left != null && this.left.containsLine(minX, maxX, minY, maxY, aX, aY, bX, bY, !splitX)) {
                return true;
            }
            if (this.right != null && (!splitX && maxY >= this.component.getMinY() || splitX && maxX >= this.component.getMinX())) {
                return this.right.containsLine(minX, maxX, minY, maxY, aX, aY, bX, bY, !splitX);
            }
        }
        return false;
    }

    @Override
    public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        return this.containsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, false);
    }

    private boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY, boolean splitX) {
        if (minY <= this.maxY && minX <= this.maxX) {
            if (this.component.containsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY)) {
                return true;
            }
            if (this.left != null && this.left.containsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, !splitX)) {
                return true;
            }
            if (this.right != null && (!splitX && maxY >= this.component.getMinY() || splitX && maxX >= this.component.getMinX())) {
                return this.right.containsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, !splitX);
            }
        }
        return false;
    }

    @Override
    public Component2D.WithinRelation withinPoint(double x, double y) {
        if (this.left != null || this.right != null) {
            throw new IllegalArgumentException("withinPoint is not supported for shapes with more than one component");
        }
        return this.component.withinPoint(x, y);
    }

    @Override
    public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
        if (this.left != null || this.right != null) {
            throw new IllegalArgumentException("withinLine is not supported for shapes with more than one component");
        }
        return this.component.withinLine(minX, maxX, minY, maxY, aX, aY, ab, bX, bY);
    }

    @Override
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (this.left != null || this.right != null) {
            throw new IllegalArgumentException("withinTriangle is not supported for shapes with more than one component");
        }
        return this.component.withinTriangle(minX, maxX, minY, maxY, aX, aY, ab, bX, bY, bc, cX, cY, ca);
    }

    @Override
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        return this.relate(minX, maxX, minY, maxY, false);
    }

    private PointValues.Relation relate(double minX, double maxX, double minY, double maxY, boolean splitX) {
        if (minY <= this.maxY && minX <= this.maxX) {
            PointValues.Relation relation = this.component.relate(minX, maxX, minY, maxY);
            if (relation != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.left != null && (relation = this.left.relate(minX, maxX, minY, maxY, !splitX)) != PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return relation;
            }
            if (this.right != null && (!splitX && maxY >= this.component.getMinY() || splitX && maxX >= this.component.getMinX())) {
                relation = this.right.relate(minX, maxX, minY, maxY, !splitX);
                return relation;
            }
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    static Component2D create(Component2D[] components) {
        if (components.length == 1) {
            return components[0];
        }
        ComponentTree root = ComponentTree.createTree(components, 0, components.length - 1, false);
        for (Component2D component : components) {
            root.minY = Math.min(root.minY, component.getMinY());
            root.minX = Math.min(root.minX, component.getMinX());
        }
        return root;
    }

    private static ComponentTree createTree(Component2D[] components, int low, int high, boolean splitX) {
        if (low > high) {
            return null;
        }
        int mid = low + high >>> 1;
        if (low < high) {
            if (splitX) {
                ArrayUtil.select(components, low, high + 1, mid, X_COMPARATOR);
            } else {
                ArrayUtil.select(components, low, high + 1, mid, Y_COMPARATOR);
            }
        }
        ComponentTree newNode = new ComponentTree(components[mid]);
        newNode.left = ComponentTree.createTree(components, low, mid - 1, !splitX);
        newNode.right = ComponentTree.createTree(components, mid + 1, high, !splitX);
        if (newNode.left != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.left.getMaxX());
            newNode.maxY = Math.max(newNode.maxY, newNode.left.getMaxY());
        }
        if (newNode.right != null) {
            newNode.maxX = Math.max(newNode.maxX, newNode.right.getMaxX());
            newNode.maxY = Math.max(newNode.maxY, newNode.right.getMaxY());
        }
        return newNode;
    }
}

