/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.template.put;

import java.io.IOException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.cluster.metadata.ComponentTemplate;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class PutComponentTemplateAction
extends ActionType<AcknowledgedResponse> {
    public static final PutComponentTemplateAction INSTANCE = new PutComponentTemplateAction();
    public static final String NAME = "cluster:admin/component_template/put";

    private PutComponentTemplateAction() {
        super(NAME, AcknowledgedResponse::new);
    }

    public static class Request
    extends ClusterManagerNodeRequest<Request> {
        private final String name;
        @Nullable
        private String cause;
        private boolean create;
        private ComponentTemplate componentTemplate;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
            this.cause = in.readOptionalString();
            this.create = in.readBoolean();
            this.componentTemplate = new ComponentTemplate(in);
        }

        public Request(String name) {
            this.name = name;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
            out.writeOptionalString(this.cause);
            out.writeBoolean(this.create);
            this.componentTemplate.writeTo(out);
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.name == null || !Strings.hasText((String)this.name)) {
                validationException = ValidateActions.addValidationError("name is missing", validationException);
            }
            if (this.componentTemplate == null) {
                validationException = ValidateActions.addValidationError("a component template is required", validationException);
            }
            return validationException;
        }

        public String name() {
            return this.name;
        }

        public Request create(boolean create) {
            this.create = create;
            return this;
        }

        public boolean create() {
            return this.create;
        }

        public Request cause(@Nullable String cause) {
            this.cause = cause;
            return this;
        }

        @Nullable
        public String cause() {
            return this.cause;
        }

        public Request componentTemplate(ComponentTemplate template) {
            this.componentTemplate = template;
            return this;
        }

        public ComponentTemplate componentTemplate() {
            return this.componentTemplate;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PutComponentRequest[");
            sb.append("name=").append(this.name);
            sb.append(", cause=").append(this.cause);
            sb.append(", create=").append(this.create);
            sb.append(", component_template=").append(this.componentTemplate);
            sb.append("]");
            return sb.toString();
        }
    }
}

