/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BgpStatus {
    UP("up"),
    DOWN("down"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BgpStatus> VALUE_MAP;
    private final String value;

    private BgpStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BgpStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BgpStatus> knownValues() {
        EnumSet<BgpStatus> knownValues = EnumSet.allOf(BgpStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BgpStatus.class, BgpStatus::toString);
    }
}

