/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.geospatial;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class UpdateStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, UpdateStats> {
    @Nullable
    private final Long lastProcessingTimeInMillis;
    @Nullable
    private final Long lastSucceededAtInEpochMillis;
    public static final JsonpDeserializer<UpdateStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateStats::setupUpdateStatsDeserializer);

    private UpdateStats(Builder builder) {
        this.lastProcessingTimeInMillis = builder.lastProcessingTimeInMillis;
        this.lastSucceededAtInEpochMillis = builder.lastSucceededAtInEpochMillis;
    }

    public static UpdateStats of(Function<Builder, ObjectBuilder<UpdateStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long lastProcessingTimeInMillis() {
        return this.lastProcessingTimeInMillis;
    }

    @Nullable
    public final Long lastSucceededAtInEpochMillis() {
        return this.lastSucceededAtInEpochMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.lastProcessingTimeInMillis != null) {
            generator.writeKey("last_processing_time_in_millis");
            generator.write(this.lastProcessingTimeInMillis.longValue());
        }
        if (this.lastSucceededAtInEpochMillis != null) {
            generator.writeKey("last_succeeded_at_in_epoch_millis");
            generator.write(this.lastSucceededAtInEpochMillis.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUpdateStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::lastProcessingTimeInMillis, JsonpDeserializer.longDeserializer(), "last_processing_time_in_millis");
        op.add(Builder::lastSucceededAtInEpochMillis, JsonpDeserializer.longDeserializer(), "last_succeeded_at_in_epoch_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.lastProcessingTimeInMillis);
        result = 31 * result + Objects.hashCode(this.lastSucceededAtInEpochMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateStats other = (UpdateStats)o;
        return Objects.equals(this.lastProcessingTimeInMillis, other.lastProcessingTimeInMillis) && Objects.equals(this.lastSucceededAtInEpochMillis, other.lastSucceededAtInEpochMillis);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, UpdateStats> {
        @Nullable
        private Long lastProcessingTimeInMillis;
        @Nullable
        private Long lastSucceededAtInEpochMillis;

        public Builder() {
        }

        private Builder(UpdateStats o) {
            this.lastProcessingTimeInMillis = o.lastProcessingTimeInMillis;
            this.lastSucceededAtInEpochMillis = o.lastSucceededAtInEpochMillis;
        }

        private Builder(Builder o) {
            this.lastProcessingTimeInMillis = o.lastProcessingTimeInMillis;
            this.lastSucceededAtInEpochMillis = o.lastSucceededAtInEpochMillis;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder lastProcessingTimeInMillis(@Nullable Long value) {
            this.lastProcessingTimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder lastSucceededAtInEpochMillis(@Nullable Long value) {
            this.lastSucceededAtInEpochMillis = value;
            return this;
        }

        @Override
        @Nonnull
        public UpdateStats build() {
            this._checkSingleUse();
            return new UpdateStats(this);
        }
    }
}

