/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.sgd.linear;

import com.oracle.labs.mlrg.olcut.config.Config;
import java.util.logging.Logger;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Output;
import org.tribuo.classification.Label;
import org.tribuo.classification.sgd.LabelObjective;
import org.tribuo.classification.sgd.linear.LinearSGDModel;
import org.tribuo.classification.sgd.objectives.LogMulticlass;
import org.tribuo.common.sgd.AbstractLinearSGDTrainer;
import org.tribuo.common.sgd.SGDObjective;
import org.tribuo.math.LinearParameters;
import org.tribuo.math.StochasticGradientOptimiser;
import org.tribuo.provenance.ModelProvenance;

public class LinearSGDTrainer
extends AbstractLinearSGDTrainer<Label, Integer, LinearSGDModel> {
    private static final Logger logger = Logger.getLogger(LinearSGDTrainer.class.getName());
    @Config(description="The classification objective function to use.")
    private LabelObjective objective = new LogMulticlass();

    public LinearSGDTrainer(LabelObjective objective, StochasticGradientOptimiser optimiser, int epochs, int loggingInterval, int minibatchSize, long seed) {
        super(optimiser, epochs, loggingInterval, minibatchSize, seed);
        this.objective = objective;
    }

    public LinearSGDTrainer(LabelObjective objective, StochasticGradientOptimiser optimiser, int epochs, int loggingInterval, long seed) {
        this(objective, optimiser, epochs, loggingInterval, 1, seed);
    }

    public LinearSGDTrainer(LabelObjective objective, StochasticGradientOptimiser optimiser, int epochs, long seed) {
        this(objective, optimiser, epochs, 1000, 1, seed);
    }

    private LinearSGDTrainer() {
    }

    protected Integer getTarget(ImmutableOutputInfo<Label> outputInfo, Label output) {
        return outputInfo.getID((Output)output);
    }

    protected SGDObjective<Integer> getObjective() {
        return this.objective;
    }

    protected LinearSGDModel createModel(String name, ModelProvenance provenance, ImmutableFeatureMap featureMap, ImmutableOutputInfo<Label> outputInfo, LinearParameters parameters) {
        return new LinearSGDModel(name, provenance, featureMap, outputInfo, parameters, this.objective.getNormalizer(), this.objective.isProbabilistic());
    }

    protected String getModelClassName() {
        return LinearSGDModel.class.getName();
    }

    public String toString() {
        return "LinearSGDTrainer(objective=" + this.objective.toString() + ",optimiser=" + this.optimiser.toString() + ",epochs=" + this.epochs + ",minibatchSize=" + this.minibatchSize + ",seed=" + this.seed + ")";
    }
}

