/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.provenance;

import com.oracle.labs.mlrg.olcut.provenance.ListProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.provenance.TrainerProvenance;

public class EnsembleModelProvenance
extends ModelProvenance {
    private static final long serialVersionUID = 1L;
    protected static final String MEMBERS = "member-provenance";
    private final ListProvenance<? extends ModelProvenance> memberProvenance;

    public EnsembleModelProvenance(String className, OffsetDateTime time, DatasetProvenance datasetProvenance, TrainerProvenance trainerProvenance, ListProvenance<? extends ModelProvenance> memberProvenance) {
        super(className, time, datasetProvenance, trainerProvenance);
        this.memberProvenance = memberProvenance;
    }

    public EnsembleModelProvenance(String className, OffsetDateTime time, DatasetProvenance datasetProvenance, TrainerProvenance trainerProvenance, Map<String, Provenance> instanceProvenance, ListProvenance<? extends ModelProvenance> memberProvenance) {
        this(className, time, datasetProvenance, trainerProvenance, instanceProvenance, true, memberProvenance);
    }

    public EnsembleModelProvenance(String className, OffsetDateTime time, DatasetProvenance datasetProvenance, TrainerProvenance trainerProvenance, Map<String, Provenance> instanceProvenance, boolean trackSystem, ListProvenance<? extends ModelProvenance> memberProvenance) {
        super(className, time, datasetProvenance, trainerProvenance, instanceProvenance, trackSystem);
        this.memberProvenance = memberProvenance;
    }

    public EnsembleModelProvenance(Map<String, Provenance> map) {
        super(map);
        this.memberProvenance = (ListProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)MEMBERS, ListProvenance.class, (String)EnsembleModelProvenance.class.getSimpleName());
    }

    public ListProvenance<? extends ModelProvenance> getMemberProvenance() {
        return this.memberProvenance;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnsembleModelProvenance pairs = (EnsembleModelProvenance)o;
        return this.memberProvenance.equals(pairs.memberProvenance);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.memberProvenance);
    }

    @Override
    public String toString() {
        return this.generateString("EnsembleModel");
    }

    @Override
    protected List<Pair<String, Provenance>> internalProvenances() {
        List<Pair<String, Provenance>> superList = super.internalProvenances();
        superList.add((Pair<String, Provenance>)new Pair((Object)MEMBERS, this.memberProvenance));
        return superList;
    }
}

