/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray.index.full;

import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.index.dim.NDIndexAll;
import ai.djl.ndarray.index.dim.NDIndexElement;
import ai.djl.ndarray.index.dim.NDIndexFixed;
import ai.djl.ndarray.index.dim.NDIndexSlice;
import ai.djl.ndarray.types.Shape;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class NDIndexFullSlice {
    private long[] min;
    private long[] max;
    private long[] step;
    private int[] toSqueeze;
    private Shape shape;
    private Shape squeezedShape;

    private NDIndexFullSlice(long[] min, long[] max, long[] step, int[] toSqueeze, Shape shape, Shape squeezedShape) {
        this.min = min;
        this.max = max;
        this.step = step;
        this.toSqueeze = toSqueeze;
        this.shape = shape;
        this.squeezedShape = squeezedShape;
    }

    public static Optional<NDIndexFullSlice> fromIndex(NDIndex index, Shape target) {
        int paddingDim;
        if (!index.stream().allMatch(ie -> ie instanceof NDIndexAll || ie instanceof NDIndexFixed || ie instanceof NDIndexSlice)) {
            return Optional.empty();
        }
        int ellipsisIndex = index.getEllipsisIndex();
        int indDimensions = index.getRank();
        int targetDimensions = target.dimension();
        if (indDimensions > target.dimension()) {
            throw new IllegalArgumentException("The index has too many dimensions - " + indDimensions + " dimensions for array with " + targetDimensions + " dimensions");
        }
        long[] min = new long[targetDimensions];
        long[] max = new long[targetDimensions];
        long[] step = new long[targetDimensions];
        ArrayList<Integer> toSqueeze = new ArrayList<Integer>(targetDimensions);
        long[] shape = new long[targetDimensions];
        ArrayList<Long> squeezedShape = new ArrayList<Long>(targetDimensions);
        if (ellipsisIndex == -1 || ellipsisIndex == indDimensions) {
            int i2;
            for (i2 = 0; i2 < indDimensions; ++i2) {
                NDIndexElement ie2 = index.get(i2);
                NDIndexFullSlice.addSliceInfo(ie2, i2, target, min, max, step, toSqueeze, shape, squeezedShape);
            }
            for (i2 = indDimensions; i2 < target.dimension(); ++i2) {
                NDIndexFullSlice.padIndexAll(i2, target, min, max, step, shape, squeezedShape);
            }
        } else if (ellipsisIndex == 0) {
            int i3;
            paddingDim = targetDimensions - indDimensions;
            for (i3 = 0; i3 < paddingDim; ++i3) {
                NDIndexFullSlice.padIndexAll(i3, target, min, max, step, shape, squeezedShape);
            }
            while (i3 < targetDimensions) {
                NDIndexElement ie3 = index.get(i3 - paddingDim);
                NDIndexFullSlice.addSliceInfo(ie3, i3, target, min, max, step, toSqueeze, shape, squeezedShape);
                ++i3;
            }
        } else {
            NDIndexElement ie4;
            int i4;
            paddingDim = targetDimensions - indDimensions;
            for (i4 = 0; i4 < ellipsisIndex; ++i4) {
                ie4 = index.get(i4);
                NDIndexFullSlice.addSliceInfo(ie4, i4, target, min, max, step, toSqueeze, shape, squeezedShape);
            }
            while (i4 < paddingDim + ellipsisIndex) {
                NDIndexFullSlice.padIndexAll(i4, target, min, max, step, shape, squeezedShape);
                ++i4;
            }
            while (i4 < targetDimensions) {
                ie4 = index.get(i4 - paddingDim);
                NDIndexFullSlice.addSliceInfo(ie4, i4, target, min, max, step, toSqueeze, shape, squeezedShape);
                ++i4;
            }
        }
        int[] squeeze = toSqueeze.stream().mapToInt(i -> i).toArray();
        NDIndexFullSlice fullSlice = new NDIndexFullSlice(min, max, step, squeeze, new Shape(shape), new Shape(squeezedShape));
        return Optional.of(fullSlice);
    }

    private static void addSliceInfo(NDIndexElement ie, int i, Shape target, long[] min, long[] max, long[] step, List<Integer> toSqueeze, long[] shape, List<Long> squeezedShape) {
        if (ie instanceof NDIndexFixed) {
            NDIndexFixed fixed = (NDIndexFixed)ie;
            long rawIndex = fixed.getIndex();
            min[i] = rawIndex < 0L ? Math.floorMod(rawIndex, target.get(i)) : rawIndex;
            max[i] = min[i] + 1L;
            step[i] = 1L;
            toSqueeze.add(i);
            shape[i] = 1L;
        } else if (ie instanceof NDIndexSlice) {
            NDIndexSlice slice = (NDIndexSlice)ie;
            long rawMin = Optional.ofNullable(slice.getMin()).orElse(0L);
            min[i] = rawMin < 0L ? Math.floorMod(rawMin, target.get(i)) : rawMin;
            long rawMax = Optional.ofNullable(slice.getMax()).orElse(target.size(i));
            max[i] = rawMax < 0L ? Math.floorMod(rawMax, target.get(i)) : rawMax;
            step[i] = Optional.ofNullable(slice.getStep()).orElse(1L);
            shape[i] = (long)Math.ceil((double)(max[i] - min[i]) / (double)step[i]);
            squeezedShape.add(shape[i]);
        } else if (ie instanceof NDIndexAll) {
            NDIndexFullSlice.padIndexAll(i, target, min, max, step, shape, squeezedShape);
        }
    }

    private static void padIndexAll(int i, Shape target, long[] min, long[] max, long[] step, long[] shape, List<Long> squeezedShape) {
        min[i] = 0L;
        max[i] = target.size(i);
        step[i] = 1L;
        shape[i] = target.size(i);
        squeezedShape.add(target.size(i));
    }

    public long[] getMin() {
        return this.min;
    }

    public long[] getMax() {
        return this.max;
    }

    public long[] getStep() {
        return this.step;
    }

    public int[] getToSqueeze() {
        return this.toSqueeze;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Shape getSqueezedShape() {
        return this.squeezedShape;
    }
}

