/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.AbstractHashingFunction;
import com.password4j.BadParametersException;
import com.password4j.Hash;
import com.password4j.HashingFunction;
import com.password4j.PBKDF2Function;
import com.password4j.SaltGenerator;
import com.password4j.Utils;
import com.password4j.types.Hmac;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ScryptFunction
extends AbstractHashingFunction {
    public static final int DERIVED_KEY_LENGTH = 64;
    private static final ConcurrentMap<String, ScryptFunction> INSTANCES = new ConcurrentHashMap<String, ScryptFunction>();
    private int workFactor;
    private int resources;
    private int parallelization;
    private int derivedKeyLength;

    private ScryptFunction() {
    }

    protected ScryptFunction(int workFactor, int resources, int parallelization) {
        this.resources = resources;
        this.workFactor = workFactor;
        this.parallelization = parallelization;
        this.derivedKeyLength = 64;
    }

    protected ScryptFunction(int workFactor, int resources, int parallelization, int derivedKeyLength) {
        this.resources = resources;
        this.workFactor = workFactor;
        this.parallelization = parallelization;
        this.derivedKeyLength = derivedKeyLength;
    }

    public static ScryptFunction getInstanceFromHash(String hashed) {
        String[] parts = hashed.split("\\$");
        if (parts.length == 4) {
            long params = Long.parseLong(parts[1], 16);
            int workFactor = (int)Math.pow(2.0, params >> 16 & 0xFFFFL);
            int resources = (int)params >> 8 & 0xFF;
            int parallelization = (int)params & 0xFF;
            int derivedKeyLength = Utils.decodeBase64(parts[3]).length;
            return ScryptFunction.getInstance(workFactor, resources, parallelization, derivedKeyLength);
        }
        throw new BadParametersException("`" + hashed + "` is not a valid hash");
    }

    public static ScryptFunction getInstance(int workFactor, int resources, int parallelization) {
        return ScryptFunction.getInstance(workFactor, resources, parallelization, 64);
    }

    public static ScryptFunction getInstance(int workFactor, int resources, int parallelization, int derivedKeyLength) {
        String key = ScryptFunction.getUID(resources, workFactor, parallelization, derivedKeyLength);
        if (INSTANCES.containsKey(key)) {
            return (ScryptFunction)INSTANCES.get(key);
        }
        ScryptFunction function = new ScryptFunction(workFactor, resources, parallelization, derivedKeyLength);
        INSTANCES.put(key, function);
        return function;
    }

    protected static String toString(int resources, int workFactor, int parallelization, int derivedKeyLength) {
        return "N=" + workFactor + ", r=" + resources + ", p=" + parallelization + ", l=" + derivedKeyLength;
    }

    protected static String getUID(int resources, int workFactor, int parallelization, int derivedKeyLength) {
        return workFactor + "|" + resources + "|" + parallelization + "|" + derivedKeyLength;
    }

    public static int rOperation(int a, int b) {
        return a << b | a >>> 32 - b;
    }

    public static void salsa208(byte[] xArray) {
        int i;
        int[] b32 = new int[16];
        int[] x = new int[16];
        for (i = 0; i < 16; ++i) {
            b32[i] = xArray[i * 4] & 0xFF;
            int n = i;
            b32[n] = b32[n] | (xArray[i * 4 + 1] & 0xFF) << 8;
            int n2 = i;
            b32[n2] = b32[n2] | (xArray[i * 4 + 2] & 0xFF) << 16;
            int n3 = i;
            b32[n3] = b32[n3] | (xArray[i * 4 + 3] & 0xFF) << 24;
        }
        System.arraycopy(b32, 0, x, 0, 16);
        for (i = 8; i > 0; i -= 2) {
            x[4] = x[4] ^ ScryptFunction.rOperation(x[0] + x[12], 7);
            x[8] = x[8] ^ ScryptFunction.rOperation(x[4] + x[0], 9);
            x[12] = x[12] ^ ScryptFunction.rOperation(x[8] + x[4], 13);
            x[0] = x[0] ^ ScryptFunction.rOperation(x[12] + x[8], 18);
            x[9] = x[9] ^ ScryptFunction.rOperation(x[5] + x[1], 7);
            x[13] = x[13] ^ ScryptFunction.rOperation(x[9] + x[5], 9);
            x[1] = x[1] ^ ScryptFunction.rOperation(x[13] + x[9], 13);
            x[5] = x[5] ^ ScryptFunction.rOperation(x[1] + x[13], 18);
            x[14] = x[14] ^ ScryptFunction.rOperation(x[10] + x[6], 7);
            x[2] = x[2] ^ ScryptFunction.rOperation(x[14] + x[10], 9);
            x[6] = x[6] ^ ScryptFunction.rOperation(x[2] + x[14], 13);
            x[10] = x[10] ^ ScryptFunction.rOperation(x[6] + x[2], 18);
            x[3] = x[3] ^ ScryptFunction.rOperation(x[15] + x[11], 7);
            x[7] = x[7] ^ ScryptFunction.rOperation(x[3] + x[15], 9);
            x[11] = x[11] ^ ScryptFunction.rOperation(x[7] + x[3], 13);
            x[15] = x[15] ^ ScryptFunction.rOperation(x[11] + x[7], 18);
            x[1] = x[1] ^ ScryptFunction.rOperation(x[0] + x[3], 7);
            x[2] = x[2] ^ ScryptFunction.rOperation(x[1] + x[0], 9);
            x[3] = x[3] ^ ScryptFunction.rOperation(x[2] + x[1], 13);
            x[0] = x[0] ^ ScryptFunction.rOperation(x[3] + x[2], 18);
            x[6] = x[6] ^ ScryptFunction.rOperation(x[5] + x[4], 7);
            x[7] = x[7] ^ ScryptFunction.rOperation(x[6] + x[5], 9);
            x[4] = x[4] ^ ScryptFunction.rOperation(x[7] + x[6], 13);
            x[5] = x[5] ^ ScryptFunction.rOperation(x[4] + x[7], 18);
            x[11] = x[11] ^ ScryptFunction.rOperation(x[10] + x[9], 7);
            x[8] = x[8] ^ ScryptFunction.rOperation(x[11] + x[10], 9);
            x[9] = x[9] ^ ScryptFunction.rOperation(x[8] + x[11], 13);
            x[10] = x[10] ^ ScryptFunction.rOperation(x[9] + x[8], 18);
            x[12] = x[12] ^ ScryptFunction.rOperation(x[15] + x[14], 7);
            x[13] = x[13] ^ ScryptFunction.rOperation(x[12] + x[15], 9);
            x[14] = x[14] ^ ScryptFunction.rOperation(x[13] + x[12], 13);
            x[15] = x[15] ^ ScryptFunction.rOperation(x[14] + x[13], 18);
        }
        for (i = 0; i < 16; ++i) {
            int n = i;
            b32[n] = b32[n] + x[i];
        }
        for (i = 0; i < 16; ++i) {
            xArray[i * 4] = (byte)(b32[i] & 0xFF);
            xArray[i * 4 + 1] = (byte)(b32[i] >> 8 & 0xFF);
            xArray[i * 4 + 2] = (byte)(b32[i] >> 16 & 0xFF);
            xArray[i * 4 + 3] = (byte)(b32[i] >> 24 & 0xFF);
        }
    }

    public static void blockXOR(byte[] sArray, int si, byte[] dArray, int di, int length) {
        for (int i = 0; i < length; ++i) {
            int n = di + i;
            dArray[n] = (byte)(dArray[n] ^ sArray[si + i]);
        }
    }

    @Override
    public Hash hash(CharSequence plainTextPassword) {
        byte[] salt = SaltGenerator.generate();
        return this.internalHash(Utils.fromCharSequenceToBytes(plainTextPassword), salt);
    }

    @Override
    public Hash hash(byte[] plainTextPasswordAsBytes) {
        byte[] salt = SaltGenerator.generate();
        return this.internalHash(plainTextPasswordAsBytes, salt);
    }

    @Override
    public Hash hash(CharSequence plainTextPassword, String salt) {
        byte[] saltAsBytes = Utils.fromCharSequenceToBytes(salt);
        byte[] plainTextPasswordAsBytes = Utils.fromCharSequenceToBytes(plainTextPassword);
        return this.internalHash(plainTextPasswordAsBytes, saltAsBytes);
    }

    @Override
    public Hash hash(byte[] plainTextPasswordAsBytes, byte[] salt) {
        return this.internalHash(plainTextPasswordAsBytes, salt);
    }

    private Hash internalHash(byte[] plainTextPassword, byte[] salt) {
        try {
            byte[] derived = this.scrypt(plainTextPassword, salt, this.derivedKeyLength);
            String params = Long.toString((long)Utils.log2(this.workFactor) << 16 | (long)this.resources << 8 | (long)this.parallelization, 16);
            String sb = "$" + params + '$' + Utils.encodeBase64(salt) + '$' + Utils.encodeBase64(derived);
            return new Hash((HashingFunction)this, sb, derived, salt);
        }
        catch (IllegalArgumentException | GeneralSecurityException e) {
            String stringedSalt = Utils.fromBytesToString(salt);
            String message = "Invalid specification with salt=" + stringedSalt + ", N=" + this.workFactor + ", r=" + this.resources + " and p=" + this.parallelization;
            throw new BadParametersException(message, e);
        }
    }

    @Override
    public boolean check(CharSequence plainTextPassword, String hashed) {
        return this.check(Utils.fromCharSequenceToBytes(plainTextPassword), Utils.fromCharSequenceToBytes(hashed));
    }

    @Override
    public boolean check(byte[] plainTextPassword, byte[] hashed) {
        try {
            List<byte[]> parts = Utils.split(hashed, (byte)36);
            if (parts.size() == 4) {
                byte[] salt = Utils.decodeBase64(parts.get(2));
                byte[] derived0 = Utils.decodeBase64(parts.get(3));
                byte[] derived1 = this.scrypt(plainTextPassword, salt, this.derivedKeyLength);
                return ScryptFunction.slowEquals(derived0, derived1);
            }
            throw new BadParametersException("Invalid hashed value");
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalStateException("JVM doesn't support SHA1PRNG or HMAC_SHA256?", gse);
        }
    }

    public long getRequiredBytes() {
        return 128L * (long)this.workFactor * (long)this.resources * (long)this.parallelization;
    }

    public int getWorkFactor() {
        return this.workFactor;
    }

    public int getResources() {
        return this.resources;
    }

    public int getParallelization() {
        return this.parallelization;
    }

    public int getDerivedKeyLength() {
        return this.derivedKeyLength;
    }

    public String getRequiredMemory() {
        long memoryInBytes = this.getRequiredBytes();
        if (memoryInBytes > 1000000L) {
            return (double)Math.round((float)memoryInBytes / 10000.0f) / 100.0 + "MB";
        }
        if (memoryInBytes > 1000L) {
            return (double)Math.round((float)memoryInBytes / 1000.0f) / 100.0 + "KB";
        }
        return memoryInBytes + "B";
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScryptFunction otherStrategy = (ScryptFunction)obj;
        return this.workFactor == otherStrategy.workFactor && this.resources == otherStrategy.resources && this.parallelization == otherStrategy.parallelization;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + ScryptFunction.toString(this.resources, this.workFactor, this.parallelization, this.derivedKeyLength) + ')';
    }

    public int hashCode() {
        return Objects.hash(this.resources, this.workFactor, this.parallelization);
    }

    public byte[] scrypt(byte[] passwd, byte[] salt, int dkLen) throws GeneralSecurityException {
        if (this.workFactor >= 2 && (this.workFactor & this.workFactor - 1) == 0) {
            if (this.workFactor > 0xFFFFFF / this.resources) {
                throw new IllegalArgumentException("Parameter N is too large");
            }
            if (this.resources > 0xFFFFFF / this.parallelization) {
                throw new IllegalArgumentException("Parameter r is too large");
            }
            byte[] xyArray = new byte[256 * this.resources];
            byte[] vArray = new byte[128 * this.resources * this.workFactor];
            byte[] intensiveSalt = PBKDF2Function.internalHash(Utils.fromBytesToString(passwd).toCharArray(), salt, Hmac.SHA256.name(), 1, 8 * this.parallelization * 128 * this.resources).getEncoded();
            for (int i = 0; i < this.parallelization; ++i) {
                this.sMix(intensiveSalt, i * 128 * this.resources, vArray, xyArray);
            }
            return PBKDF2Function.internalHash(Utils.fromBytesToString(passwd).toCharArray(), intensiveSalt, Hmac.SHA256.name(), 1, 8 * dkLen).getEncoded();
        }
        throw new IllegalArgumentException("N must be a power of 2 greater than 1. Found " + this.workFactor);
    }

    public void sMix(byte[] intensiveSalt, int bi, byte[] vArray, byte[] xyArray) {
        int i;
        int xi = 0;
        int yi = 128 * this.resources;
        System.arraycopy(intensiveSalt, bi, xyArray, xi, 128 * this.resources);
        for (i = 0; i < this.workFactor; ++i) {
            System.arraycopy(xyArray, xi, vArray, i * 128 * this.resources, 128 * this.resources);
            this.blockmixSalsa8(xyArray, xi, yi);
        }
        for (i = 0; i < this.workFactor; ++i) {
            int j = this.integerify(xyArray, xi) & this.workFactor - 1;
            ScryptFunction.blockXOR(vArray, j * 128 * this.resources, xyArray, xi, 128 * this.resources);
            this.blockmixSalsa8(xyArray, xi, yi);
        }
        System.arraycopy(xyArray, xi, intensiveSalt, bi, 128 * this.resources);
    }

    public void blockmixSalsa8(byte[] xyArray, int bi, int yi) {
        int i;
        byte[] xArray = new byte[64];
        System.arraycopy(xyArray, bi + (2 * this.resources - 1) * 64, xArray, 0, 64);
        for (i = 0; i < 2 * this.resources; ++i) {
            ScryptFunction.blockXOR(xyArray, i * 64, xArray, 0, 64);
            ScryptFunction.salsa208(xArray);
            System.arraycopy(xArray, 0, xyArray, yi + i * 64, 64);
        }
        for (i = 0; i < this.resources; ++i) {
            System.arraycopy(xyArray, yi + i * 2 * 64, xyArray, bi + i * 64, 64);
        }
        for (i = 0; i < this.resources; ++i) {
            System.arraycopy(xyArray, yi + (i * 2 + 1) * 64, xyArray, bi + (i + this.resources) * 64, 64);
        }
    }

    public int integerify(byte[] xyArray, int xi) {
        int n = xyArray[xi += (2 * this.resources - 1) * 64] & 0xFF;
        n |= (xyArray[xi + 1] & 0xFF) << 8;
        n |= (xyArray[xi + 2] & 0xFF) << 16;
        return n |= (xyArray[xi + 3] & 0xFF) << 24;
    }
}

