/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandActivityList
extends SingleLineCommand2<ActivityDiagram3> {
    public CommandActivityList() {
        super(CommandActivityList.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandActivityList.class.getName(), RegexLeaf.start(), new RegexLeaf("[-*]"), RegexLeaf.spaceZeroOrOne(), StereotypePattern.optional("STEREO1"), new RegexLeaf(1, "LABEL", "(.*?)"), StereotypePattern.optional("STEREO2"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        Url url;
        String stereo = arg.getLazzy("STEREO", 0);
        Stereotype stereotype = null;
        if (stereo != null) {
            stereotype = Stereotype.build(stereo);
        }
        if (arg.get("URL", 0) == null) {
            url = null;
        } else {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            url = urlBuilder.getUrl(arg.get("URL", 0));
        }
        return diagram.addActivity(Display.getWithNewlines(diagram.getPragma(), arg.get("LABEL", 0)), BoxStyle.PLAIN, url, Colors.empty(), stereotype);
    }
}

