/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.TablePointer;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableConstraintType;
import us.fatehi.utility.Utility;

class MutableTableConstraint
extends AbstractDependantObject<Table>
implements TableConstraint {
    private static final long serialVersionUID = 1155277343302693656L;
    private final NamedObjectList<MutableTableConstraintColumn> columns = new NamedObjectList();
    private String definition = "";
    private boolean deferrable;
    private boolean initiallyDeferred;
    private TableConstraintType tableConstraintType;

    MutableTableConstraint(Table parent, String name) {
        super(new TablePointer(parent), name);
    }

    @Override
    public List<TableConstraintColumn> getConstrainedColumns() {
        return new ArrayList<TableConstraintColumn>(this.columns.values());
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    @Override
    public TableConstraintType getType() {
        if (this.tableConstraintType != null) {
            return this.tableConstraintType;
        }
        return TableConstraintType.unknown;
    }

    @Override
    public final boolean hasDefinition() {
        return !Utility.isBlank(this.definition);
    }

    @Override
    public boolean isDeferrable() {
        return this.deferrable;
    }

    @Override
    public boolean isInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    final void addColumn(MutableTableConstraintColumn column) {
        this.columns.add(column);
    }

    final void setDeferrable(boolean deferrable) {
        this.deferrable = deferrable;
    }

    final void setDefinition(String definition) {
        if (!this.hasDefinition() && !Utility.isBlank(definition)) {
            this.definition = definition;
        }
    }

    final void setInitiallyDeferred(boolean initiallyDeferred) {
        this.initiallyDeferred = initiallyDeferred;
    }

    final void setTableConstraintType(TableConstraintType tableConstraintType) {
        this.tableConstraintType = tableConstraintType;
    }
}

