\name{BinaryReconstructionByDilationImageFilter}
\alias{BinaryReconstructionByDilationImageFilter}
\title{BinaryReconstructionByDilationImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
binary reconstruction by dilation of an image
BinaryReconstructionByDilationImageFilter}
\details{
Reconstruction by dilation operates on a "marker" image and a
"mask" image, and is defined as the dilation of the marker image
with respect to the mask image iterated until stability.
Geodesic morphology is described in Chapter 6.2 of Pierre Soille's
book "Morphological Image Analysis: Principles and Applications",
Second Edition, Springer, 2003.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
See:
MorphologyImageFilter , ReconstructionByDilationImageFilter , BinaryReconstructionByErosionImageFilter
BinaryReconstructionByDilation for the procedural interface
itk::BinaryReconstructionByDilationImageFilter for the Doxygen on the original ITK class.
BinaryReconstructionByDilationImageFilter}
%C++ includes: sitkBinaryReconstructionByDilationImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryReconstructionByDilationImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &markerImage, const Image &maskImage):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{double GetBackgroundValue() const:}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{double GetForegroundValue() const:}{
Set/Get the value used as "foreground" in the output image. Defaults
to NumericTraits<PixelType>::max() .
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set/Get the value used as "foreground" in the output image. Defaults
to NumericTraits<PixelType>::max() .
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryReconstructionByDilationImageFilter():}{
Destructor
}
}
}
